/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.sqlbuilder.impl.postgresql;

import java.util.Map;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.sqlbuilder.AbstractSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.impl.AbstractInsertSqlBuilder;

public class PostgreSqlInsertSqlBuilder
extends AbstractInsertSqlBuilder {
    public PostgreSqlInsertSqlBuilder(SmartDbNode smartDbNode) {
        super(smartDbNode);
    }

    @Override
    public SupportDatabaseType getSupportDatabaseType() {
        return SupportDatabaseType.POSTGRE_SQL;
    }

    @Override
    public String generateSql(boolean isPretty) {
        StringBuilder insertClause = new StringBuilder();
        insertClause.append("insert into ");
        insertClause.append(this.table);
        insertClause.append(" ( ");
        StringBuilder valuesClause = new StringBuilder();
        valuesClause.append(" values (");
        if (this.columnAndParam.size() > 0) {
            int count = 1;
            for (Map.Entry entry : this.columnAndParam.entrySet()) {
                boolean isNotLast;
                insertClause.append("\"").append((String)entry.getKey()).append("\"");
                AbstractInsertSqlBuilder.InsertParamObject paramObject = (AbstractInsertSqlBuilder.InsertParamObject)entry.getValue();
                if (paramObject.isSqlFunction()) {
                    valuesClause.append(" ").append(paramObject.getParam());
                } else {
                    valuesClause.append(" ").append("?");
                }
                boolean bl = isNotLast = count < this.columnAndParam.size();
                if (isNotLast) {
                    insertClause.append(",");
                    valuesClause.append(",");
                }
                ++count;
            }
        }
        insertClause.append(" )");
        valuesClause.append(" )");
        insertClause.append(isPretty ? AbstractSqlBuilder.LINE_SEPARATOR : " ");
        insertClause.append((CharSequence)valuesClause);
        if (this.useGeneratedKeyFields != null && this.useGeneratedKeyFields[0].getField() != null) {
            String fieldName = this.useGeneratedKeyFields[0].getField().getName();
            insertClause.append(" returning ").append(fieldName).append(";");
        }
        insertClause.append((CharSequence)this.appendSqlBuilder);
        return insertClause.toString();
    }
}

