/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.lab1024.smartdb.SmartDbConfig;
import net.lab1024.smartdb.SmartDbHelper;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.TransactionRunnable;
import net.lab1024.smartdb.TransactionSmartDbNode;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.datasource.SmartDbDataSource;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.handler.AbstractListHandler;
import net.lab1024.smartdb.mapping.handler.ResultSetHandler;
import net.lab1024.smartdb.mapping.handler.ResultSetHandlerFactory;
import net.lab1024.smartdb.mapping.handler.ScalarHandler;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.mapping.rowconvertor.RowConverter;
import net.lab1024.smartdb.pagination.PaginateParam;
import net.lab1024.smartdb.pagination.PaginateResult;
import net.lab1024.smartdb.sqlbuilder.DeleteSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.InsertSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.ReplaceSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.SelectSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.UpdateSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.convertor.ColumnNameConverter;
import net.lab1024.smartdb.sqlbuilder.convertor.TableNameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmartDbNode
implements SmartDbNode {
    protected static Logger LOG = LoggerFactory.getLogger(AbstractSmartDbNode.class);
    protected static final Object[] EMPTY_PARAM = new Object[0];
    protected ResultSetHandlerFactory resultSetHandlerFactory;
    protected SmartDbConfig smartDbConfig;
    protected SmartDbDataSource smartDbDataSource;

    public AbstractSmartDbNode(SmartDbDataSource dataSource, SmartDbConfig smartDbConfig) {
        this.smartDbDataSource = dataSource;
        this.smartDbConfig = smartDbConfig;
        this.resultSetHandlerFactory = new ResultSetHandlerFactory(smartDbConfig.getRowConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runTransaction(TransactionRunnable transactionRunnable) {
        TransactionSmartDbNode transactionSmartDb = null;
        try {
            transactionSmartDb = this.getTransaction();
            transactionSmartDb.begin();
            boolean result = transactionRunnable.run(transactionSmartDb);
            if (result) {
                transactionSmartDb.commit();
            } else {
                transactionSmartDb.rollback();
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            if (transactionSmartDb != null) {
                try {
                    transactionSmartDb.rollback();
                }
                catch (Exception e1) {
                    LOG.error("", (Throwable)e1);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (transactionSmartDb != null) {
                    transactionSmartDb.releaseConnection();
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.smartDbDataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runTransaction(TransactionRunnable transactionRunnable, int transactionLevel) {
        TransactionSmartDbNode transactionSmartDb = null;
        try {
            transactionSmartDb = this.getTransaction();
            transactionSmartDb.begin(transactionLevel);
            boolean result = transactionRunnable.run(transactionSmartDb);
            if (result) {
                transactionSmartDb.commit();
            } else {
                transactionSmartDb.rollback();
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            if (transactionSmartDb != null) {
                try {
                    transactionSmartDb.rollback();
                }
                catch (Exception e1) {
                    LOG.error("", (Throwable)e1);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (transactionSmartDb != null) {
                    transactionSmartDb.releaseConnection();
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    @Override
    public SmartDbDataSource getDataSource() {
        return this.smartDbDataSource;
    }

    @Override
    public RowConverter getRowConverter() {
        return this.smartDbConfig.getRowConverter();
    }

    public boolean isShowSql() {
        return this.smartDbConfig.isShowSql();
    }

    @Override
    public ColumnNameConverter getColumnNameConverter() {
        return this.smartDbConfig.getColumnNameConverter();
    }

    @Override
    public TableNameConverter getTableNameConverter() {
        return this.smartDbConfig.getTableNameConverter();
    }

    @Override
    public SelectSqlBuilder selectSqlBuilder() {
        return this.smartDbConfig.getSupportDatabaseType().getSqlBuilderFactory().select(this);
    }

    @Override
    public InsertSqlBuilder insertSqlBuilder() {
        return this.smartDbConfig.getSupportDatabaseType().getSqlBuilderFactory().insert(this);
    }

    @Override
    public UpdateSqlBuilder updateSqlBuilder() {
        return this.smartDbConfig.getSupportDatabaseType().getSqlBuilderFactory().update(this);
    }

    @Override
    public DeleteSqlBuilder deleteSqlBuilder() {
        return this.smartDbConfig.getSupportDatabaseType().getSqlBuilderFactory().delete(this);
    }

    @Override
    public ReplaceSqlBuilder replaceSqlBuilder() {
        return this.smartDbConfig.getSupportDatabaseType().getSqlBuilderFactory().replace(this);
    }

    @Override
    public SupportDatabaseType getSupportDatabaseType() {
        return this.smartDbConfig.getSupportDatabaseType();
    }

    @Override
    public int execute(String sql) {
        return this.execute(sql, EMPTY_PARAM);
    }

    @Override
    public int execute(DeleteSqlBuilder deleteSqlBuilder) {
        return this.execute(deleteSqlBuilder.generateSql(false), deleteSqlBuilder.getAllParams());
    }

    @Override
    public int execute(InsertSqlBuilder insertSqlBuilder) {
        return this.execute(insertSqlBuilder.generateSql(false), insertSqlBuilder.getAllParams());
    }

    @Override
    public int execute(UpdateSqlBuilder updateSqlBuilder) {
        return this.execute(updateSqlBuilder.generateSql(false), updateSqlBuilder.getAllParams());
    }

    @Override
    public int execute(String sql, Object ... params) {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            this.showSql(sql, params);
            SmartDbHelper.setParams(stmt, params);
            int n = stmt.executeUpdate();
            return n;
        }
        catch (Throwable t) {
            throw new SmartDbException(String.format("executeCommand error, sql:%s params:%s", sql, SmartDbHelper.toString(params)), t);
        }
        finally {
            this.releaseResources(null, stmt, conn);
        }
    }

    @Override
    public int execute(String sql, List<Object> params) {
        return this.execute(sql, params == null ? EMPTY_PARAM : params.toArray(new Object[params.size()]));
    }

    @Override
    public int[] batch(String sql, Collection<Object[]> paramsCollection) {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            this.showSql(sql, paramsCollection);
            for (Object[] params : paramsCollection) {
                if (!SmartDbHelper.setParams(stmt, params)) continue;
                stmt.addBatch();
            }
            Object object = stmt.executeBatch();
            return object;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.releaseResources(null, stmt, conn);
        }
    }

    @Override
    public <T> List<T> batchInsert(List<T> tList) {
        return this.commonBatchInsert(tList, false);
    }

    protected <T> List<T> commonBatchInsert(List<T> tList, boolean isSelective) {
        if (tList == null || tList.isEmpty()) {
            return tList;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            T t = tList.get(0);
            OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(t.getClass());
            InsertSqlBuilder insertSqlBuilder = this.insertSqlBuilder();
            if (isSelective) {
                insertSqlBuilder.insertEntitySelective(t);
            } else {
                insertSqlBuilder.insertEntity(t);
            }
            String sql = insertSqlBuilder.generateSql();
            ArrayList paramsArrayList = Lists.newArrayListWithExpectedSize((int)tList.size());
            try {
                for (T t1 : tList) {
                    ArrayList<Object> paramsList = new ArrayList<Object>();
                    OrmClassFieldMeta[] primaryKeyFields = classMeta.getPrimaryKeyFields();
                    for (int i = 0; i < primaryKeyFields.length; ++i) {
                        OrmClassFieldMeta f = primaryKeyFields[i];
                        Object o = f.getField().get(t1);
                        if (o == null) continue;
                        paramsList.add(o);
                    }
                    for (OrmClassFieldMeta f : classMeta.getColumnsFields()) {
                        Object o = f.getField().get(t1);
                        if (isSelective && o == null) continue;
                        paramsList.add(o);
                    }
                    paramsArrayList.add(paramsList.toArray());
                }
            }
            catch (IllegalAccessException e) {
                throw new SmartDbException(e);
            }
            conn = this.getConnection();
            stmt = classMeta.isUseGeneratedKey() ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this.showSql(sql, paramsArrayList);
            for (Object[] params : paramsArrayList) {
                if (!SmartDbHelper.setParams(stmt, params)) continue;
                stmt.addBatch();
            }
            stmt.executeBatch();
            if (!Objects.equal((Object)SupportDatabaseType.ORACLE, (Object)this.smartDbConfig.getSupportDatabaseType()) && classMeta.isUseGeneratedKey()) {
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                int tIndex = 0;
                while (generatedKeys.next()) {
                    classMeta.injectGeneratedKeys(generatedKeys, tList.get(tIndex));
                    ++tIndex;
                }
            }
            List<T> list = tList;
            this.releaseResources(null, stmt, conn);
            return list;
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException(t);
            }
            catch (Throwable throwable) {
                this.releaseResources(null, stmt, conn);
                throw throwable;
            }
        }
    }

    @Override
    public <T> List<T> batchInsertSelective(List<T> tList) {
        return this.commonBatchInsert(tList, true);
    }

    @Override
    public <T> T query(ResultSetHandler<T> handler, SelectSqlBuilder selectSqlBuilder) {
        return this.query(handler, selectSqlBuilder.generateSql(false), selectSqlBuilder.getAllParams());
    }

    @Override
    public <T> T query(ResultSetHandler<T> handler, String sql) {
        return this.query(handler, sql, EMPTY_PARAM);
    }

    @Override
    public <T> T query(ResultSetHandler<T> handler, String sql, Object ... params) {
        T t;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            SmartDbHelper.setParams(stmt, params);
            this.showSql(sql, params);
            rs = stmt.executeQuery();
            t = handler.handle(rs);
            this.releaseResources(rs, stmt, conn);
        }
        catch (Throwable t2) {
            try {
                throw new SmartDbException(t2);
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, stmt, conn);
                throw throwable;
            }
        }
        return t;
    }

    @Override
    public <T> T query(ResultSetHandler<T> handler, String sql, List<Object> params) {
        return this.query(handler, sql, params == null ? EMPTY_PARAM : params.toArray(new Object[params.size()]));
    }

    @Override
    public <T> T queryFirst(Class<T> cls, SelectSqlBuilder selectSqlBuilder) {
        return this.queryFirst(cls, selectSqlBuilder.generateSql(false), selectSqlBuilder.getAllParams());
    }

    @Override
    public <T> T queryFirst(Class<T> cls, String sql) {
        return this.queryFirst(cls, sql, EMPTY_PARAM);
    }

    @Override
    public <T> T queryFirst(Class<T> cls, String sql, Object ... params) {
        T t;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            this.showSql(sql, params);
            SmartDbHelper.setParams(stmt, params);
            rs = stmt.executeQuery();
            t = this.resultSetHandlerFactory.getObjectResultHandler(cls).handle(rs);
            this.releaseResources(rs, stmt, conn);
        }
        catch (Throwable t2) {
            try {
                throw new SmartDbException(t2);
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, stmt, conn);
                throw throwable;
            }
        }
        return t;
    }

    @Override
    public <T> T queryFirst(Class<T> cls, String sql, List<Object> params) {
        return this.queryFirst(cls, sql, params == null ? EMPTY_PARAM : params.toArray(new Object[params.size()]));
    }

    @Override
    public <T> List<T> queryList(Class<T> cls, SelectSqlBuilder selectSqlBuilder) {
        return this.queryList(cls, selectSqlBuilder.generateSql(false), selectSqlBuilder.getAllParams());
    }

    @Override
    public <T> List<T> queryList(Class<T> cls, String sql) {
        return this.queryList(cls, sql, EMPTY_PARAM);
    }

    @Override
    public <T> List<T> queryList(Class<T> cls, String sql, Object ... params) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            SmartDbHelper.setParams(stmt, params);
            this.showSql(sql, params);
            rs = stmt.executeQuery();
            List list = (List)this.resultSetHandlerFactory.getObjectListResultHandler(cls).handle(rs);
            this.releaseResources(rs, stmt, conn);
            return list;
        }
        catch (Throwable t) {
            try {
                throw new SmartDbException(t);
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, stmt, conn);
                throw throwable;
            }
        }
    }

    @Override
    public <T> List<T> queryList(Class<T> cls, String sql, List<Object> params) {
        return this.queryList(cls, sql, params == null ? EMPTY_PARAM : params.toArray(new Object[params.size()]));
    }

    @Override
    public <T> PaginateResult<T> paginate(AbstractListHandler<T> handler, PaginateParam paginateParam, String sql, List<Object> params) {
        return this.paginate(handler, paginateParam, sql, params == null ? EMPTY_PARAM : params.toArray(new Object[params.size()]));
    }

    @Override
    public <T> PaginateResult<T> paginate(AbstractListHandler<T> handler, PaginateParam paginateParam, String sql, Object ... params) {
        int pageNumber = paginateParam.getPageNumber();
        int pageSize = paginateParam.getPageSize();
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        Long total = 0L;
        if (paginateParam.isSearchCount()) {
            String totalRowSql = this.getSupportDatabaseType().getPaginateSqlGenerator().generateCountSql(pageNumber, pageSize, sql);
            total = this.query(ScalarHandler.Long, totalRowSql, params);
            if (total == null || total == 0L) {
                return new PaginateResult(pageNumber, pageSize);
            }
            int pageCount = (int)(total / (long)pageSize);
            if (total % (long)pageSize != 0L) {
                ++pageCount;
            }
            if (pageNumber > pageCount) {
                return new PaginateResult(new ArrayList(0), total, pageNumber, pageSize);
            }
        }
        String pageSql = this.getSupportDatabaseType().getPaginateSqlGenerator().generatePaginateSql(pageNumber, pageSize, sql);
        List list = (List)this.query(handler, pageSql, params);
        return new PaginateResult(list, total, pageNumber, pageSize);
    }

    @Override
    public <T> PaginateResult<T> paginate(AbstractListHandler<T> handler, PaginateParam paginateParam, SelectSqlBuilder selectSqlBuilder) {
        return this.paginate(handler, paginateParam, selectSqlBuilder.generateSql(false), selectSqlBuilder.getAllParams().toArray(new Object[selectSqlBuilder.getAllParams().size()]));
    }

    @Override
    public <T> PaginateResult<T> paginate(Class<T> cls, PaginateParam paginateParam, String sql, List<Object> params) {
        return this.paginate(cls, paginateParam, sql, params == null ? EMPTY_PARAM : params.toArray(new Object[params.size()]));
    }

    @Override
    public <T> PaginateResult<T> paginate(Class<T> handler, PaginateParam paginateParam, String sql, Object ... params) {
        int pageNumber = paginateParam.getPageNumber();
        int pageSize = paginateParam.getPageSize();
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        Long total = 0L;
        if (paginateParam.isSearchCount()) {
            String totalRowSql = this.getSupportDatabaseType().getPaginateSqlGenerator().generateCountSql(pageNumber, pageSize, sql);
            total = this.query(ScalarHandler.Long, totalRowSql, params);
            if (total == null || total == 0L) {
                return new PaginateResult(pageNumber, pageSize);
            }
            int pageCount = (int)(total / (long)pageSize);
            if (total % (long)pageSize != 0L) {
                ++pageCount;
            }
            if (pageNumber > pageCount) {
                return new PaginateResult(new ArrayList(0), total, pageNumber, pageSize);
            }
        }
        String pageSql = this.getSupportDatabaseType().getPaginateSqlGenerator().generatePaginateSql(pageNumber, pageSize, sql);
        List<T> list = this.queryList(handler, pageSql, params);
        return new PaginateResult<T>(list, total, pageNumber, pageSize);
    }

    @Override
    public <T> PaginateResult<T> paginate(Class<T> cls, PaginateParam paginateParam, SelectSqlBuilder selectSqlBuilder) {
        return this.paginate(cls, paginateParam, selectSqlBuilder.generateSql(false), selectSqlBuilder.getAllParams().toArray(new Object[selectSqlBuilder.getAllParams().size()]));
    }

    @Override
    public <T> T insertSelective(T t) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(t.getClass());
        InsertSqlBuilder insertSqlBuilder = this.insertSqlBuilder();
        insertSqlBuilder.insertEntitySelective(t);
        if (classMeta.isUseGeneratedKey()) {
            return this.executeAndReturnGeneratedKey(insertSqlBuilder, t);
        }
        this.execute(insertSqlBuilder);
        return t;
    }

    @Override
    public <T> T insert(T t) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(t.getClass());
        InsertSqlBuilder insertSqlBuilder = this.insertSqlBuilder();
        insertSqlBuilder.insertEntity(t);
        if (classMeta.isUseGeneratedKey()) {
            return this.executeAndReturnGeneratedKey(insertSqlBuilder, t);
        }
        this.execute(insertSqlBuilder);
        return t;
    }

    public <T> T executeAndReturnGeneratedKey(InsertSqlBuilder insertSqlBuilder, T t) {
        T t2;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = insertSqlBuilder.generateSql();
        List<Object> allParams = insertSqlBuilder.getAllParams();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql, 1);
            SmartDbHelper.setParams(stmt, allParams);
            this.showSql(sql, allParams);
            stmt.executeUpdate();
            OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(t.getClass());
            if (!Objects.equal((Object)SupportDatabaseType.ORACLE, (Object)this.smartDbConfig.getSupportDatabaseType()) && classMeta.isUseGeneratedKey() && (rs = stmt.getGeneratedKeys()).next()) {
                classMeta.injectGeneratedKeys(rs, t);
            }
            t2 = t;
            this.releaseResources(rs, stmt, conn);
        }
        catch (Throwable throwable) {
            try {
                throw new SmartDbException(String.format("executeCommand error, sql:%s params:%s", sql, SmartDbHelper.toString(allParams)), throwable);
            }
            catch (Throwable throwable2) {
                this.releaseResources(rs, stmt, conn);
                throw throwable2;
            }
        }
        return t2;
    }

    @Override
    public <T> int updateSelective(T t) {
        UpdateSqlBuilder updateSqlBuilder = this.updateSqlBuilder();
        updateSqlBuilder.updateEntitySelective(t);
        return this.execute(updateSqlBuilder);
    }

    @Override
    public <T> int update(T t) {
        UpdateSqlBuilder updateSqlBuilder = this.updateSqlBuilder();
        updateSqlBuilder.updateEntity(t);
        return this.execute(updateSqlBuilder);
    }

    @Override
    public <T> int delete(T t) {
        DeleteSqlBuilder deleteSqlBuilder = this.deleteSqlBuilder();
        deleteSqlBuilder.deleteEntity(t);
        return this.execute(deleteSqlBuilder);
    }

    protected void showSql(String sql, Object[] params) {
        if (this.smartDbConfig.isShowSql()) {
            if (params == null || params.length == 0) {
                LOG.info("\r\n------------------------------------------------------ \r\n <<SmartDb SQL>> : {}  \r\n------------------------------------------------------ \r\n", (Object)sql);
            } else {
                List<Object> objects = Arrays.asList(params);
                LOG.info("\r\n------------------------------------------------------ \r\n <<SmartDb SQL>> : {}  \r\n <<SmartDb SQL Params>> : {} \n------------------------------------------------------ \r\n", (Object)sql, (Object)objects.toString());
            }
        }
    }

    protected void showSql(String sql, List<Object> params) {
        if (this.smartDbConfig.isShowSql()) {
            if (params == null || params.isEmpty()) {
                LOG.info("\n------------------------------------------------------ \r\n <<SmartDb SQL>> : {}  \r\n------------------------------------------------------\r\n ", (Object)sql);
            } else {
                LOG.info("\n------------------------------------------------------ \r\n <<SmartDb SQL>> : {}  \r\n <<SmartDb SQL Params>> : {} \n------------------------------------------------------\n\r ", (Object)sql, (Object)params.toString());
            }
        }
    }

    protected void showSql(String sql, Collection<Object[]> params) {
        if (this.smartDbConfig.isShowSql()) {
            if (params == null || params.isEmpty()) {
                LOG.info("\r\n------------------------------------------------------ <<SmartDb SQL>> : {}  \r\n------------------------------------------------------ \r\n ", (Object)sql);
            } else {
                LOG.info("\r\n------------------------------------------------------ <<SmartDb SQL>> : {}  \r\n------------------------------------------------------ \r\n <<SmartDb SQL Batch Params Size>> : {}  \r\n", (Object)sql, (Object)params.size());
            }
        }
    }

    public void releaseResources(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.error("cannot releaseConnection ResultSet", (Throwable)e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.error("cannot releaseConnection Statement", (Throwable)e);
            }
        }
        this.smartDbDataSource.releaseConnection(conn);
    }
}

