/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.ext.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import net.lab1024.smartdb.SmartDb;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.mapping.handler.ScalarHandler;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.pagination.PaginateParam;
import net.lab1024.smartdb.pagination.PaginateResult;
import net.lab1024.smartdb.sqlbuilder.DeleteSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.SelectSqlBuilder;

public abstract class SmartDbDao<T> {
    protected Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public long count() {
        SmartDb smartDb = this.getSmartDb();
        SelectSqlBuilder selectSqlBuilder = smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("count(1)");
        selectSqlBuilder.from(classMeta.getTableName(smartDb.getTableNameConverter()));
        return smartDb.query(ScalarHandler.Long, selectSqlBuilder);
    }

    public List<T> selectAll() {
        SmartDb smartDb = this.getSmartDb();
        SelectSqlBuilder selectSqlBuilder = smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("*");
        selectSqlBuilder.from(classMeta.getTableName(smartDb.getTableNameConverter()));
        return smartDb.queryList(this.entityClass, selectSqlBuilder);
    }

    public T selectByPrimaryKey(Serializable ... keys) {
        SmartDb smartDb = this.getSmartDb();
        SelectSqlBuilder selectSqlBuilder = smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("*");
        selectSqlBuilder.from(classMeta.getTableName(smartDb.getTableNameConverter()));
        SupportDatabaseType supportDatabaseType = smartDb.getSupportDatabaseType();
        OrmClassFieldMeta[] primaryFields = classMeta.getPrimaryKeyFields();
        for (int i = 0; i < primaryFields.length; ++i) {
            OrmClassFieldMeta f = primaryFields[i];
            String name = f.getOrmColumnName();
            selectSqlBuilder.whereAnd(String.format("%s = ?", supportDatabaseType.getSqlBuilderFactory().wrapSpecialCharacterField(name)), keys[i]);
        }
        return smartDb.queryFirst(this.entityClass, selectSqlBuilder);
    }

    public PaginateResult<T> paginate(PaginateParam paginateParam) {
        SmartDb smartDb = this.getSmartDb();
        SelectSqlBuilder selectSqlBuilder = smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("*");
        selectSqlBuilder.from(classMeta.getTableName(smartDb.getTableNameConverter()));
        return smartDb.paginate(this.entityClass, paginateParam, selectSqlBuilder);
    }

    public int delete(T t) {
        return this.getSmartDb().delete(t);
    }

    public int deleteByPrimaryKey(Serializable ... keys) {
        SmartDb smartDb = this.getSmartDb();
        DeleteSqlBuilder deleteSqlBuilder = smartDb.deleteSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        deleteSqlBuilder.table(classMeta.getTableName(smartDb.getTableNameConverter()));
        SupportDatabaseType supportDatabaseType = smartDb.getSupportDatabaseType();
        OrmClassFieldMeta[] primaryFields = classMeta.getPrimaryKeyFields();
        for (int i = 0; i < primaryFields.length; ++i) {
            OrmClassFieldMeta f = primaryFields[i];
            String name = f.getOrmColumnName();
            deleteSqlBuilder.whereAnd(String.format("%s = ?", supportDatabaseType.getSqlBuilderFactory().wrapSpecialCharacterField(name)), keys[i]);
        }
        return smartDb.execute(deleteSqlBuilder);
    }

    public int updateSelective(T t) {
        return this.getSmartDb().updateSelective(t);
    }

    public int update(T t) {
        return this.getSmartDb().update(t);
    }

    public T insert(T t) {
        return this.getSmartDb().insert(t);
    }

    public T insertSelective(T t) {
        return this.getSmartDb().insertSelective(t);
    }

    public abstract SmartDb getSmartDb();
}

