/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.handler.type;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.lab1024.smartdb.SmartDbEnum;
import net.lab1024.smartdb.mapping.handler.type.JdbcType;
import net.lab1024.smartdb.mapping.handler.type.TypeHandler;

public class SmartDbEnumTypeHandler<T extends SmartDbEnum>
implements TypeHandler<T> {
    private final Class<T> type;

    public SmartDbEnumTypeHandler(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex, JdbcType jdbcType) throws SQLException {
        SmartDbEnum[] enums;
        int result = rs.getInt(columnIndex);
        if (result == 0 && rs.wasNull()) {
            return null;
        }
        for (SmartDbEnum e : enums = (SmartDbEnum[])this.type.getEnumConstants()) {
            if (e.getValue() == null || !e.getValue().equals(result)) continue;
            return (T)e;
        }
        return null;
    }

    @Override
    public T getResult(ResultSet rs, String columnName, JdbcType jdbcType) throws SQLException {
        SmartDbEnum[] enums;
        int result = rs.getInt(columnName);
        if (result == 0 && rs.wasNull()) {
            return null;
        }
        for (SmartDbEnum e : enums = (SmartDbEnum[])this.type.getEnumConstants()) {
            if (e.getValue() == null || !e.getValue().equals(result)) continue;
            return (T)e;
        }
        return null;
    }
}

