/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.rowconvertor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.mapping.rowconvertor.ConverterClassInfo;

class ConverterClassCache {
    private static final ConcurrentHashMap<Class<?>, ConverterClassInfo> CLASS_FIELD_CACHE = new ConcurrentHashMap();

    ConverterClassCache() {
    }

    public static ConverterClassInfo getConvertClassInfo(Class<?> cls) {
        ConverterClassInfo prev;
        ConverterClassInfo clsInfo = CLASS_FIELD_CACHE.get(cls);
        if (clsInfo == null && (prev = CLASS_FIELD_CACHE.putIfAbsent(cls, clsInfo = ConverterClassCache.createConverterClassInfo(cls))) != null) {
            clsInfo = prev;
        }
        return clsInfo;
    }

    private static ConverterClassInfo createConverterClassInfo(Class<?> c) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(c);
        PropertyDescriptor[] propertyDescriptors = ConverterClassCache.propertyDescriptors(c);
        HashMap<String, Integer> fieldIndex = new HashMap<String, Integer>(propertyDescriptors.length);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            fieldIndex.put(propertyDescriptors[i].getName(), i);
        }
        ConverterClassInfo clsInfo = new ConverterClassInfo(propertyDescriptors, fieldIndex);
        return clsInfo;
    }

    private static PropertyDescriptor[] propertyDescriptors(Class<?> c) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SmartDbException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }
}

