/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.sqlbuilder.impl.mysql;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.sqlbuilder.AbstractSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.ReplaceSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.SqlBuilderType;
import net.lab1024.smartdb.sqlbuilder.convertor.ColumnNameConverter;

public class MysqlReplaceSqlBuilder
extends AbstractSqlBuilder
implements ReplaceSqlBuilder {
    protected String table;
    protected Map<String, ReplaceParamObject> columnAndParam = new LinkedHashMap<String, ReplaceParamObject>();

    public MysqlReplaceSqlBuilder(SmartDbNode smartDbNode) {
        super(smartDbNode);
    }

    @Override
    public ReplaceSqlBuilder table(String table) {
        if (table != null) {
            this.table = table;
        }
        return this;
    }

    @Override
    public ReplaceSqlBuilder table(Class clazz) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(clazz);
        if (classMeta != null) {
            this.table(classMeta.getTableName(this.tableNameConverter));
        }
        return this;
    }

    public ReplaceSqlBuilder appendSql(String sqlClause) {
        this.appendSqlBuilder.append(" ").append(sqlClause);
        return this;
    }

    @Override
    public ReplaceSqlBuilder replaceColumn(String column, Object param) {
        this.columnAndParam.put(column, new ReplaceParamObject(false, param));
        return this;
    }

    @Override
    public ReplaceSqlBuilder replaceFunctionColumn(String column, String sqlFunction) {
        this.columnAndParam.put(column, new ReplaceParamObject(true, sqlFunction));
        return this;
    }

    @Override
    public ReplaceSqlBuilder replaceEntitySelective(Object obj) {
        return this.replaceEntitySelective(obj, this.columnNameConverter);
    }

    @Override
    public ReplaceSqlBuilder replaceEntitySelective(Object obj, ColumnNameConverter nameConverter) {
        this.reflectFieldAndInsert(obj, this.columnNameConverter, true);
        return this;
    }

    private void reflectFieldAndInsert(Object obj, ColumnNameConverter columnNameConverter, boolean ignoreNull) {
        Class<?> cls = obj.getClass();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(cls);
        this.table(classMeta.getTableName(this.tableNameConverter));
        try {
            OrmClassFieldMeta[] primaryKeyFields = classMeta.getPrimaryKeyFields();
            for (int i = 0; i < primaryKeyFields.length; ++i) {
                OrmClassFieldMeta f = primaryKeyFields[i];
                Object o = f.getField().get(obj);
                if (o == null) continue;
                String name = f.getOrmColumnName();
                if (columnNameConverter != null) {
                    name = columnNameConverter.fieldConvertToColumn(name);
                }
                this.replaceColumn(name, o);
            }
            for (OrmClassFieldMeta f : classMeta.getColumnsFields()) {
                Object o = f.getField().get(obj);
                if (ignoreNull && o == null) continue;
                String name = f.getOrmColumnName();
                if (columnNameConverter != null) {
                    name = columnNameConverter.fieldConvertToColumn(name);
                }
                this.replaceColumn(name, o);
            }
        }
        catch (IllegalAccessException e) {
            throw new SmartDbException(e);
        }
    }

    @Override
    public ReplaceSqlBuilder replaceEntity(Object obj) {
        return this.replaceEntity(obj, this.columnNameConverter);
    }

    @Override
    public ReplaceSqlBuilder replaceEntity(Object obj, ColumnNameConverter nameConverter) {
        this.reflectFieldAndInsert(obj, this.columnNameConverter, false);
        return this;
    }

    @Override
    public SqlBuilderType getSqlBuilderType() {
        return SqlBuilderType.REPLACE;
    }

    @Override
    public String generateSql() {
        return this.generateSql(false);
    }

    @Override
    public String generateSql(boolean isPretty) {
        StringBuilder replaceClause = new StringBuilder();
        replaceClause.append("replace into ");
        replaceClause.append(this.table);
        replaceClause.append(" ( ");
        StringBuilder valuesClause = new StringBuilder();
        valuesClause.append(" values ( ");
        if (this.columnAndParam.size() > 0) {
            int count = 1;
            boolean isNotLast = false;
            for (Map.Entry<String, ReplaceParamObject> entry : this.columnAndParam.entrySet()) {
                replaceClause.append(entry.getKey());
                ReplaceParamObject paramObject = entry.getValue();
                if (paramObject.isSqlFunction()) {
                    valuesClause.append(" ").append(paramObject.getParam());
                } else {
                    valuesClause.append(" ").append("?");
                }
                boolean bl = isNotLast = count < this.columnAndParam.size();
                if (isNotLast) {
                    replaceClause.append(",");
                    valuesClause.append(",");
                }
                ++count;
            }
        }
        replaceClause.append(")");
        valuesClause.append(")");
        replaceClause.append(isPretty ? LINE_SEPARATOR : " ");
        replaceClause.append((CharSequence)valuesClause);
        replaceClause.append((CharSequence)this.appendSqlBuilder);
        return replaceClause.toString();
    }

    @Override
    public List<Object> getAllParams() {
        ArrayList<Object> list = new ArrayList<Object>(this.columnAndParam.size());
        for (ReplaceParamObject param : this.columnAndParam.values()) {
            if (param.isSqlFunction) continue;
            list.add(param.param);
        }
        return list;
    }

    @Override
    public SupportDatabaseType getSupportDatabaseType() {
        return SupportDatabaseType.MYSQL;
    }

    @Override
    public int execute() {
        return this.smartDbNode.execute(this);
    }

    protected class ReplaceParamObject {
        protected boolean isSqlFunction;
        Object param;

        public boolean isSqlFunction() {
            return this.isSqlFunction;
        }

        public Object getParam() {
            return this.param;
        }

        public ReplaceParamObject(boolean isSqlFunction, Object param) {
            this.isSqlFunction = isSqlFunction;
            this.param = param;
        }
    }
}

