/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.sqlbuilder.impl.oracle;

import java.util.Map;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.sqlbuilder.AbstractSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.impl.AbstractInsertSqlBuilder;

public class OracleInsertSqlBuilder
extends AbstractInsertSqlBuilder {
    public OracleInsertSqlBuilder(SmartDbNode smartDbNode) {
        super(smartDbNode);
    }

    @Override
    public String generateSql(boolean isPretty) {
        StringBuilder insertClause = new StringBuilder();
        insertClause.append("insert into ");
        insertClause.append(this.table);
        insertClause.append(" ( ");
        StringBuilder valuesClause = new StringBuilder();
        valuesClause.append(" values ( ");
        if (this.columnAndParam.size() > 0) {
            int count = 1;
            boolean isNotLast = false;
            for (Map.Entry entry : this.columnAndParam.entrySet()) {
                insertClause.append((String)entry.getKey());
                AbstractInsertSqlBuilder.InsertParamObject paramObject = (AbstractInsertSqlBuilder.InsertParamObject)entry.getValue();
                if (paramObject.isSqlFunction()) {
                    valuesClause.append(" ").append(paramObject.getParam());
                } else {
                    valuesClause.append(" ").append("?");
                }
                boolean bl = isNotLast = count < this.columnAndParam.size();
                if (isNotLast) {
                    insertClause.append(" ,");
                    valuesClause.append(" ,");
                }
                ++count;
            }
        }
        insertClause.append(")");
        valuesClause.append(")");
        insertClause.append(isPretty ? AbstractSqlBuilder.LINE_SEPARATOR : " ");
        insertClause.append((CharSequence)valuesClause);
        insertClause.append((CharSequence)this.appendSqlBuilder);
        return insertClause.toString();
    }

    @Override
    public SupportDatabaseType getSupportDatabaseType() {
        return SupportDatabaseType.ORACLE;
    }
}

