/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.KeyId;

public final class Constants {
    public static final String SCHEME = "Signature";
    public static final String CHALLENGE = "WWW-Authenticate";
    public static final String REALM = "realm";
    public static final String KEY_ID = "keyId";
    @Deprecated
    public static final String HEADER_REQUEST_LINE = "request-line";
    public static final String HEADER_REQUEST_TARGET = "(request-target)";
    public static final String HEADER_DATE = "date";
    public static final List<String> DEFAULT_HEADERS = Arrays.asList("date");
    public static final List<String> IGNORE_HEADERS = Arrays.asList("authorization");
    public static final String AUTHORIZATION = "Authorization";
    public static final String HEADERS = "headers";
    public static final String SIGNATURE = "signature";
    public static final String ALGORITHMS = "algorithms";
    public static final String ALGORITHM = "algorithm";
    public static final Charset CHARSET = Charset.forName("ISO-8859-1");
    public static final Pattern RFC2617_PARAM = Pattern.compile("(\\w+)=\"([^\"]*)\"");
    public static final KeyId DEFAULT_KEY_IDENTIFIER = new KeyId(){

        @Override
        public String getId(Key key) {
            return key.getId();
        }
    };
    public static final Collection<Algorithm> ALL_SUPPORTED_ALGORITHMS = Arrays.asList(Algorithm.values());
    public static final Challenge PREEMPTIVE_CHALLENGE = new Challenge("<preemptive>", DEFAULT_HEADERS, ALL_SUPPORTED_ALGORITHMS);

    public static List<String> parseTokens(String tokens) {
        if (tokens == null || tokens.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens.trim().split("\\s+")));
    }

    public static String constructTokensString(List<String> tokens) {
        StringBuilder sb = new StringBuilder();
        if (tokens != null && !tokens.isEmpty()) {
            for (String token : tokens) {
                sb.append(token).append(" ");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<String, String> parseRFC2617(String header) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (header != null && header.toLowerCase().startsWith(SCHEME.toLowerCase())) {
            Matcher matcher = RFC2617_PARAM.matcher(header.substring(SCHEME.length() + 1));
            while (matcher.find()) {
                params.put(matcher.group(1), matcher.group(2));
            }
        }
        return Collections.unmodifiableMap(params);
    }

    public static String constructRFC2617(Map<String, String> params) {
        StringBuilder sb = new StringBuilder("Signature ");
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                sb.append(param.getKey()).append("=\"").append(param.getValue()).append("\"").append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<String> filterHeaders(List<String> headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        ArrayList<String> _headers = new ArrayList<String>(headers.size());
        for (String header : headers) {
            if (IGNORE_HEADERS.contains(header.toLowerCase())) continue;
            _headers.add(header.toLowerCase());
        }
        return Collections.unmodifiableList(_headers);
    }

    private Constants() {
    }
}

