/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.EnumSet;

public enum PathAction {
    NOOP("-"),
    MODIFIED("U"),
    REPLACED("R"),
    ERROR("E"),
    ADDED("A"),
    DELETED("D"),
    MISSING("!"),
    UNKNOWN("?");

    private final String shortCode;

    private PathAction(String shortCode) {
        this.shortCode = shortCode;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public boolean isNoop() {
        return this == NOOP;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean canGetItem() {
        return EnumSet.of(NOOP, MODIFIED, REPLACED, ADDED).contains((Object)this);
    }

    public String toString() {
        return this.shortCode;
    }

    public static PathAction fromShortCode(String shortCode) {
        for (PathAction value : PathAction.values()) {
            if (!value.getShortCode().equals(shortCode)) continue;
            return value;
        }
        return UNKNOWN;
    }
}

