/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public enum Severity {
    MINOR(2),
    MAJOR(1),
    SEVERE(0);

    private final int ordinal;

    private Severity(int ordinal) {
        this.ordinal = ordinal;
    }

    public static Severity byName(@NotNull String name) {
        for (Severity value : Severity.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown severity level: " + name);
    }

    public boolean isLessSevereThan(Severity other) {
        return this.ordinal > other.ordinal;
    }

    public Predicate<Severity> meetsMinimumSeverity() {
        return other -> !other.isLessSevereThan(this);
    }

    public Severity maxSeverity(@NotNull Severity other) {
        return this.isLessSevereThan(other) ? other : this;
    }
}

