/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.Collection;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import net.adamcin.oakpal.api.ApiConstants;
import net.adamcin.oakpal.api.JsonObjectConvertible;
import net.adamcin.oakpal.api.Severity;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface Violation
extends JsonObjectConvertible {
    public Severity getSeverity();

    public Collection<PackageId> getPackages();

    public String getDescription();

    @Override
    default public JsonObject toJson() {
        JsonObjectBuilder json = Json.createObjectBuilder();
        if (this.getSeverity() != null) {
            json.add(ApiConstants.violationKeys().severity(), this.getSeverity().toString());
        }
        if (this.getDescription() != null) {
            json.add(ApiConstants.violationKeys().description(), this.getDescription());
        }
        if (this.getPackages() != null && !this.getPackages().isEmpty()) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (PackageId packageId : this.getPackages()) {
                array.add(packageId.toString());
            }
            json.add(ApiConstants.violationKeys().packages(), (JsonValue)array.build());
        }
        return json.build();
    }
}

