/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.Objects;
import net.adamcin.oakpal.api.SlingOpenable;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.jetbrains.annotations.NotNull;

public final class EmbeddedPackageInstallable
implements SlingOpenable<JcrPackage> {
    @NotNull
    private final PackageId parentId;
    @NotNull
    private final String jcrPath;
    @NotNull
    private final PackageId embeddedId;

    public EmbeddedPackageInstallable(@NotNull PackageId parentId, @NotNull String jcrPath, @NotNull PackageId embeddedId) {
        this.parentId = parentId;
        this.jcrPath = jcrPath;
        this.embeddedId = embeddedId;
    }

    @Override
    @NotNull
    public PackageId getParentId() {
        return this.parentId;
    }

    @Override
    @NotNull
    public String getJcrPath() {
        return this.jcrPath;
    }

    @NotNull
    public PackageId getEmbeddedId() {
        return this.embeddedId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedPackageInstallable that = (EmbeddedPackageInstallable)o;
        return this.parentId.equals((Object)that.parentId) && this.jcrPath.equals(that.jcrPath) && this.embeddedId.equals((Object)that.embeddedId);
    }

    public int hashCode() {
        return Objects.hash(this.parentId, this.jcrPath, this.embeddedId);
    }
}

