/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.adamcin.oakpal.api.Nothing;
import net.adamcin.oakpal.api.Result;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Fun {
    private Fun() {
    }

    public static <T> Stream<T> streamIt(@Nullable T element) {
        return element != null ? Stream.of(element) : Stream.empty();
    }

    public static <T> Stream<T> streamOpt(@NotNull Optional<T> element) {
        return element.map(Stream::of).orElse(Stream.empty());
    }

    @NotNull
    public static <T> Function<T, T> tee(@NotNull Consumer<? super T> consumer) {
        return input -> {
            consumer.accept(input);
            return input;
        };
    }

    @NotNull
    public static <T, R> Function<T, R> constantly1(@NotNull Supplier<? extends R> supplier) {
        return input -> supplier.get();
    }

    @NotNull
    public static <K, V, R> BiFunction<K, V, R> constantly2(@NotNull Supplier<? extends R> supplier) {
        return (input0, input1) -> supplier.get();
    }

    public static <T, I, R> Function<T, R> compose1(@NotNull Function<T, ? extends I> before, @NotNull Function<? super I, ? extends R> after) {
        return before.andThen(after);
    }

    public static <R, S> Supplier<S> compose0(@NotNull Supplier<? extends R> before, @NotNull Function<? super R, ? extends S> after) {
        Function composed = Fun.compose1(Fun.constantly1(before), after);
        return () -> composed.apply(Nothing.instance);
    }

    public static <K, V, I, R> BiFunction<K, V, R> compose2(@NotNull BiFunction<K, V, ? extends I> before, @NotNull Function<? super I, ? extends R> after) {
        return before.andThen(after);
    }

    public static <T, P> Predicate<T> composeTest1(@NotNull Function<? super T, ? extends P> inputFunction, @NotNull Predicate<? super P> testResult) {
        return input -> testResult.test((Object)inputFunction.apply(input));
    }

    public static <K, V, P, Q> BiPredicate<K, V> composeTest2(@NotNull Function<? super K, ? extends P> inputTFunction, @NotNull Function<? super V, ? extends Q> inputUFunction, @NotNull BiPredicate<? super P, ? super Q> testResult) {
        return (inputK, inputV) -> testResult.test((Object)inputTFunction.apply((Object)inputK), (Object)inputUFunction.apply((Object)inputV));
    }

    public static <K, V, P> BiPredicate<K, V> composeTest2(@NotNull BiFunction<? super K, ? super V, ? extends P> inputFunction, @NotNull Predicate<? super P> testResult) {
        return (inputK, inputV) -> testResult.test((Object)inputFunction.apply((Object)inputK, (Object)inputV));
    }

    public static <T> Consumer<T> toVoid1(@NotNull Function<? super T, ?> inputFunction) {
        return inputFunction::apply;
    }

    public static <K, V> BiConsumer<K, V> toVoid2(@NotNull BiFunction<? super K, ? super V, ?> inputFunction) {
        return inputFunction::apply;
    }

    public static <T, R> Function<T, R> infer1(@NotNull Function<? super T, ? extends R> methodRef) {
        return methodRef::apply;
    }

    public static <K, V, R> BiFunction<K, V, R> infer2(@NotNull BiFunction<? super K, ? super V, ? extends R> methodRef) {
        return methodRef::apply;
    }

    public static <T> Supplier<T> infer0(@NotNull Supplier<? extends T> methodRef) {
        return methodRef::get;
    }

    public static <T> Predicate<T> inferTest1(@NotNull Predicate<? super T> methodRef) {
        return methodRef::test;
    }

    public static <K, V> BiPredicate<K, V> inferTest2(@NotNull BiPredicate<? super K, ? super V> methodRef) {
        return methodRef::test;
    }

    public static <T> ThrowingFunction<T, Nothing> throwingVoidToNothing1(@NotNull ThrowingConsumer<? super T> mayThrowOnAccept) {
        return input -> {
            mayThrowOnAccept.tryAccept(input);
            return Nothing.instance;
        };
    }

    public static <K, V> ThrowingBiFunction<K, V, Nothing> throwingVoidToNothing2(@NotNull ThrowingBiConsumer<? super K, ? super V> mayThrowOnAccept) {
        return (inputK, inputV) -> {
            mayThrowOnAccept.tryAccept(inputK, inputV);
            return Nothing.instance;
        };
    }

    public static <K, V> Function<Map.Entry<K, V>, Map.Entry<K, V>> entryTee(@NotNull BiConsumer<? super K, ? super V> consumer) {
        return entry -> {
            consumer.accept((Object)entry.getKey(), (Object)entry.getValue());
            return entry;
        };
    }

    public static <K, V> Function<K, Map.Entry<K, V>> zipKeysWithValueFunc(@NotNull Function<? super K, ? extends V> valueFunc) {
        return key -> Fun.toEntry(key, valueFunc.apply((Object)key));
    }

    public static <K, V> Function<V, Map.Entry<K, V>> zipValuesWithKeyFunc(@NotNull Function<? super V, ? extends K> keyFunction) {
        return value -> Fun.toEntry(keyFunction.apply((Object)value), value);
    }

    public static <K, V> Map.Entry<K, V> toEntry(@Nullable K key, @Nullable V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <V> BinaryOperator<V> keepFirstMerger() {
        return (kv1, kv2) -> kv1;
    }

    public static <V> BinaryOperator<V> keepLastMerger() {
        return (kv1, kv2) -> kv2;
    }

    public static <V> BinaryOperator<V> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Fun.keepLastMerger(), LinkedHashMap::new);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entriesToMapOfType(@NotNull Supplier<Map<K, V>> mapSupplier) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Fun.keepLastMerger(), mapSupplier);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entriesToMap(@NotNull BinaryOperator<V> mergeFunction) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, LinkedHashMap::new);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entriesToMapOfType(@NotNull Supplier<Map<K, V>> mapSupplier, @NotNull BinaryOperator<V> mergeFunction) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, mapSupplier);
    }

    public static <K, V, R> Function<Map.Entry<K, V>, R> mapEntry(@NotNull BiFunction<? super K, ? super V, ? extends R> biMapFunction) {
        return entry -> biMapFunction.apply((Object)entry.getKey(), (Object)entry.getValue());
    }

    public static <K, V, W> Function<Map.Entry<K, V>, Map.Entry<K, W>> mapValue(@NotNull BiFunction<? super K, ? super V, ? extends W> valueBiFunction) {
        return entry -> Fun.toEntry(entry.getKey(), valueBiFunction.apply((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public static <K, V, W> Function<Map.Entry<K, V>, Map.Entry<K, W>> mapValue(@NotNull Function<? super V, ? extends W> valueFunction) {
        return Fun.mapValue((? super K key, ? super V value) -> valueFunction.apply((Object)value));
    }

    public static <K, V, L> Function<Map.Entry<K, V>, Map.Entry<L, V>> mapKey(@NotNull BiFunction<? super K, ? super V, ? extends L> keyBiFunction) {
        return entry -> Fun.toEntry(keyBiFunction.apply((Object)entry.getKey(), (Object)entry.getValue()), entry.getValue());
    }

    public static <K, V, L> Function<Map.Entry<K, V>, Map.Entry<L, V>> mapKey(@NotNull Function<? super K, ? extends L> keyFunction) {
        return Fun.mapKey((? super K key, ? super V value) -> keyFunction.apply((Object)key));
    }

    public static <K, V> Consumer<Map.Entry<K, V>> onEntry(@NotNull BiConsumer<? super K, ? super V> biConsumer) {
        return entry -> biConsumer.accept((Object)entry.getKey(), (Object)entry.getValue());
    }

    public static <K, V> Consumer<Map.Entry<K, V>> onKey(@NotNull Consumer<? super K> consumer) {
        return entry -> consumer.accept((Object)entry.getKey());
    }

    public static <K, V> Consumer<Map.Entry<K, V>> onValue(@NotNull Consumer<? super V> consumer) {
        return entry -> consumer.accept((Object)entry.getValue());
    }

    public static <K, V> Predicate<? super Map.Entry<K, V>> testEntry(@NotNull BiPredicate<? super K, ? super V> biPredicate) {
        return entry -> biPredicate.test((Object)entry.getKey(), (Object)entry.getValue());
    }

    public static <K, V> Predicate<? super Map.Entry<K, V>> testValue(@NotNull Predicate<? super V> valuePredicate) {
        return Fun.testEntry((key, value) -> valuePredicate.test((Object)value));
    }

    public static <K, V> Predicate<? super Map.Entry<K, V>> testKey(@NotNull Predicate<? super K> keyPredicate) {
        return Fun.testEntry((key, value) -> keyPredicate.test((Object)key));
    }

    public static <T, S extends Collection<? super T>> Predicate<T> inSet(@NotNull S haystack) {
        return haystack::contains;
    }

    public static <K, M extends Map<? super K, ?>> Predicate<K> isKeyIn(@NotNull M haystack) {
        return haystack::containsKey;
    }

    public static <V, M extends Map<?, ? super V>> Predicate<V> isValueIn(@NotNull M haystack) {
        return haystack::containsValue;
    }

    public static <M, T, R> Function<T, M> composeTry1(@NotNull Function<? super R, ? extends M> monadUnit, @NotNull Supplier<? extends M> monadZero, @NotNull ThrowingFunction<? super T, ? extends R> mayThrowOnApply, @Nullable BiConsumer<? super T, ? super Exception> onError) {
        BiConsumer<Object, Exception> consumeError = onError != null ? onError : (e, t) -> {};
        return element -> {
            try {
                return monadUnit.apply((Object)mayThrowOnApply.tryApply(element));
            }
            catch (Exception error) {
                consumeError.accept(element, error);
                return monadZero.get();
            }
        };
    }

    public static <M, T, R> Function<T, M> composeTry1(@NotNull Function<? super R, ? extends M> monoidSuccess, @NotNull Function<? super Exception, ? extends M> monoidError, @NotNull ThrowingFunction<? super T, ? extends R> mayThrowOnApply) {
        return element -> {
            try {
                return monoidSuccess.apply((Object)mayThrowOnApply.tryApply(element));
            }
            catch (Exception error) {
                return monoidError.apply(error);
            }
        };
    }

    public static <M, R> Supplier<M> composeTry0(@NotNull Function<? super R, ? extends M> monadUnit, @NotNull Supplier<? extends M> monadZero, @NotNull ThrowingSupplier<? extends R> mayThrowOnGet, @Nullable Consumer<? super Exception> onError) {
        Consumer<? super Exception> consumeError = onError != null ? onError : t -> {};
        return () -> {
            try {
                return monadUnit.apply((Object)mayThrowOnGet.tryGet());
            }
            catch (Exception error) {
                consumeError.accept(error);
                return monadZero.get();
            }
        };
    }

    public static <M, R> Supplier<M> composeTry0(@NotNull Function<? super R, ? extends M> monoidSuccess, @NotNull Function<? super Exception, ? extends M> monoidError, @NotNull ThrowingSupplier<? extends R> mayThrowOnGet) {
        return () -> {
            try {
                return monoidSuccess.apply((Object)mayThrowOnGet.tryGet());
            }
            catch (Exception error) {
                return monoidError.apply(error);
            }
        };
    }

    public static <M, K, V, R> BiFunction<K, V, M> composeTry2(@NotNull Function<? super R, ? extends M> monadUnit, @NotNull Supplier<? extends M> monadZero, @NotNull ThrowingBiFunction<? super K, ? super V, ? extends R> mayThrowOnApply, @Nullable BiConsumer<? super Map.Entry<? super K, ? super V>, ? super Exception> onError) {
        return (elementK, elementV) -> {
            try {
                return monadUnit.apply((Object)mayThrowOnApply.tryApply(elementK, elementV));
            }
            catch (Exception error) {
                if (onError != null) {
                    onError.accept(Fun.toEntry(elementK, elementV), error);
                }
                return monadZero.get();
            }
        };
    }

    public static <M, K, V, R> BiFunction<K, V, M> composeTry2(@NotNull Function<? super R, ? extends M> monoidSuccess, @NotNull Function<? super Exception, ? extends M> monoidError, @NotNull ThrowingBiFunction<? super K, ? super V, ? extends R> mayThrowOnApply) {
        return (elementK, elementV) -> {
            try {
                return monoidSuccess.apply((Object)mayThrowOnApply.tryApply(elementK, elementV));
            }
            catch (Exception error) {
                return monoidError.apply(error);
            }
        };
    }

    public static <R> Supplier<R> uncheck0(@NotNull ThrowingSupplier<? extends R> mayThrowOnGet) {
        return () -> {
            try {
                return mayThrowOnGet.tryGet();
            }
            catch (Exception e) {
                throw new FunRuntimeException(e);
            }
        };
    }

    public static <R> Supplier<Result<R>> result0(@NotNull ThrowingSupplier<? extends R> mayThrowOnGet) {
        return Fun.composeTry0(Result::success, Result::failure, mayThrowOnGet);
    }

    public static <T, R> Function<T, R> uncheck1(@NotNull ThrowingFunction<? super T, ? extends R> mayThrowOnApply) {
        return input -> {
            try {
                return mayThrowOnApply.tryApply(input);
            }
            catch (Exception e) {
                throw new FunRuntimeException(e);
            }
        };
    }

    public static <T, R> Function<T, Result<R>> result1(@NotNull ThrowingFunction<? super T, ? extends R> mayThrowOnApply) {
        return Fun.composeTry1(Result::success, Result::failure, mayThrowOnApply);
    }

    public static <K, V, R> BiFunction<K, V, R> uncheck2(@NotNull ThrowingBiFunction<? super K, ? super V, ? extends R> mayThrowOnApply) {
        return (inputK, inputV) -> {
            try {
                return mayThrowOnApply.tryApply(inputK, inputV);
            }
            catch (Exception e) {
                throw new FunRuntimeException(e);
            }
        };
    }

    public static <K, V, R> BiFunction<K, V, Result<R>> result2(@NotNull ThrowingBiFunction<? super K, ? super V, ? extends R> mayThrowOnApply) {
        return Fun.composeTry2(Result::success, Result::failure, mayThrowOnApply);
    }

    public static <T> Predicate<T> uncheckTest1(@NotNull ThrowingPredicate<? super T> mayThrowOnTest) {
        return input -> {
            try {
                return mayThrowOnTest.tryTest(input);
            }
            catch (Exception e) {
                throw new FunRuntimeException(e);
            }
        };
    }

    public static <K, V> BiPredicate<K, V> uncheckTest2(@NotNull ThrowingBiPredicate<? super K, ? super V> mayThrowOnTest) {
        return (inputK, inputV) -> {
            try {
                return mayThrowOnTest.tryTest(inputK, inputV);
            }
            catch (Exception e) {
                throw new FunRuntimeException(e);
            }
        };
    }

    public static <T> Consumer<T> uncheckVoid1(@NotNull ThrowingConsumer<? super T> mayThrowOnAccept) {
        return input -> {
            try {
                mayThrowOnAccept.tryAccept(input);
            }
            catch (Exception e) {
                throw new FunRuntimeException(e);
            }
        };
    }

    public static <T> Function<T, Result<Nothing>> resultNothing1(@NotNull ThrowingConsumer<? super T> mayThrowOnAccept) {
        return Fun.result1(Fun.throwingVoidToNothing1(mayThrowOnAccept));
    }

    public static <K, V> BiConsumer<K, V> uncheckVoid2(@NotNull ThrowingBiConsumer<? super K, ? super V> mayThrowOnAccept) {
        return (inputK, inputV) -> {
            try {
                mayThrowOnAccept.tryAccept(inputK, inputV);
            }
            catch (Exception e) {
                throw new FunRuntimeException(e);
            }
        };
    }

    public static <K, V> BiFunction<K, V, Result<Nothing>> resultNothing2(@NotNull ThrowingBiConsumer<? super K, ? super V> mayThrowOnAccept) {
        return Fun.result2(Fun.throwingVoidToNothing2(mayThrowOnAccept));
    }

    public static <T> Predicate<T> testOrDefault1(@NotNull ThrowingPredicate<? super T> mayThrowOnTest, boolean defaultValue) {
        return Fun.compose1(Fun.result1(mayThrowOnTest::tryTest), result -> result.getOrDefault(defaultValue))::apply;
    }

    public static <K, V> BiPredicate<K, V> testOrDefault2(@NotNull ThrowingBiPredicate<? super K, ? super V> mayThrowOnTest, boolean defaultValue) {
        return Fun.compose2(Fun.result2(mayThrowOnTest::tryTest), result -> result.getOrDefault(defaultValue))::apply;
    }

    public static <R> Supplier<R> tryOrDefault0(@NotNull ThrowingSupplier<R> mayThrowOnGet, @Nullable R defaultValue) {
        return Fun.compose0(Fun.result0(mayThrowOnGet), result -> result.getOrDefault(defaultValue));
    }

    public static <T, R> Function<T, R> tryOrDefault1(@NotNull ThrowingFunction<? super T, R> mayThrowOnApply, @Nullable R defaultValue) {
        return Fun.compose1(Fun.result1(mayThrowOnApply), result -> result.getOrDefault(defaultValue));
    }

    public static <K, V, R> BiFunction<K, V, R> tryOrDefault2(@NotNull ThrowingBiFunction<? super K, ? super V, R> mayThrowOnApply, @Nullable R defaultValue) {
        return Fun.compose2(Fun.result2(mayThrowOnApply), result -> result.getOrDefault(defaultValue));
    }

    public static <R> Supplier<Optional<R>> tryOrOptional0(@NotNull ThrowingSupplier<R> mayThrowOnGet) {
        return Fun.compose0(Fun.result0(mayThrowOnGet), Result::toOptional);
    }

    public static <T, R> Function<T, Optional<R>> tryOrOptional1(@NotNull ThrowingFunction<? super T, R> mayThrowOnApply) {
        return Fun.compose1(Fun.result1(mayThrowOnApply), Result::toOptional);
    }

    public static <K, V, R> BiFunction<K, V, Optional<R>> tryOrOptional2(@NotNull ThrowingBiFunction<? super K, ? super V, R> mayThrowOnApply) {
        return Fun.compose2(Fun.result2(mayThrowOnApply), Result::toOptional);
    }

    public static <T> Consumer<T> tryOrVoid1(@NotNull ThrowingConsumer<? super T> mayThrowOnAccept) {
        return Fun.compose1(Fun.resultNothing1(mayThrowOnAccept), Result::teeLogError)::apply;
    }

    public static <K, V> BiConsumer<K, V> tryOrVoid2(@NotNull ThrowingBiConsumer<? super K, ? super V> mayThrowOnAccept) {
        return Fun.compose2(Fun.resultNothing2(mayThrowOnAccept), Result::teeLogError)::apply;
    }

    public static final class FunRuntimeException
    extends RuntimeException {
        private FunRuntimeException(@NotNull Throwable cause) {
            super(cause);
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<K, V> {
        public void tryAccept(K var1, V var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void tryAccept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<K, V, R> {
        public R tryApply(K var1, V var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R tryApply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingBiPredicate<K, V> {
        public boolean tryTest(K var1, V var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingPredicate<T> {
        public boolean tryTest(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R> {
        public R tryGet() throws Exception;
    }
}

