/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.json.JsonObject;
import net.adamcin.oakpal.api.JavaxJson;
import net.adamcin.oakpal.api.JsonObjectConvertible;
import net.adamcin.oakpal.api.RuleType;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Rule
implements JsonObjectConvertible {
    private static final JsonKeys KEYS = new JsonKeys(){

        @Override
        public String type() {
            return "type";
        }

        @Override
        public String pattern() {
            return "pattern";
        }
    };
    private final RuleType type;
    private final Pattern pattern;

    @NotNull
    public static JsonKeys keys() {
        return KEYS;
    }

    public Rule(RuleType type, Pattern pattern) {
        if (type == null) {
            throw new NullPointerException("RuleType type");
        }
        if (pattern == null) {
            throw new NullPointerException("Pattern pattern");
        }
        this.type = type;
        this.pattern = pattern;
    }

    public RuleType getType() {
        return this.type;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isInclude() {
        return this.getType() == RuleType.INCLUDE || this.getType() == RuleType.ALLOW;
    }

    public boolean isExclude() {
        return !this.isInclude();
    }

    public boolean isAllow() {
        return this.isInclude();
    }

    public boolean isDeny() {
        return this.isExclude();
    }

    public boolean matches(String value) {
        return this.getPattern().matcher(value).matches();
    }

    @Override
    public JsonObject toJson() {
        return JavaxJson.key(Rule.keys().type(), this.getType().name()).key(Rule.keys().pattern(), this.getPattern().pattern()).get();
    }

    public String toString() {
        return this.getType().name() + ":" + this.getPattern().pattern();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.type == rule.type && this.pattern.pattern().equals(rule.pattern.pattern());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.pattern.pattern()});
    }

    @ProviderType
    public static interface JsonKeys {
        public String type();

        public String pattern();
    }
}

