/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.json.JsonArray;
import javax.json.JsonObject;
import net.adamcin.oakpal.api.JavaxJson;
import net.adamcin.oakpal.api.Rule;
import net.adamcin.oakpal.api.RuleType;

public final class Rules {
    static final Pattern PATTERN_MATCH_ALL = Pattern.compile(".*");
    public static final Rule DEFAULT_DENY = new Rule(RuleType.DENY, PATTERN_MATCH_ALL);
    public static final Rule DEFAULT_ALLOW = new Rule(RuleType.ALLOW, PATTERN_MATCH_ALL);
    public static final Rule DEFAULT_EXCLUDE = new Rule(RuleType.EXCLUDE, PATTERN_MATCH_ALL);
    public static final Rule DEFAULT_INCLUDE = new Rule(RuleType.INCLUDE, PATTERN_MATCH_ALL);

    private Rules() {
    }

    public static List<Rule> fromJsonArray(JsonArray rulesArray) {
        return JavaxJson.mapArrayOfObjects(rulesArray, Rules::fromJson);
    }

    public static Rule fromJson(JsonObject ruleJson) {
        return new Rule(RuleType.fromName(ruleJson.getString(Rule.keys().type())), Pattern.compile(ruleJson.getString(Rule.keys().pattern())));
    }

    public static Rule fuzzyDefaultAllow(List<Rule> rules) {
        return Rules.fuzzyDefaultInclude(rules);
    }

    public static Rule fuzzyDefaultDeny(List<Rule> rules) {
        return Rules.fuzzyDefaultExclude(rules);
    }

    public static Rule fuzzyDefaultInclude(List<Rule> rules) {
        if (rules != null && !rules.isEmpty() && rules.get(0).isInclude()) {
            return DEFAULT_EXCLUDE;
        }
        return DEFAULT_INCLUDE;
    }

    public static Rule fuzzyDefaultExclude(List<Rule> rules) {
        if (rules != null && !rules.isEmpty() && rules.get(0).isExclude()) {
            return DEFAULT_INCLUDE;
        }
        return DEFAULT_EXCLUDE;
    }

    public static Rule lastMatch(List<Rule> rules, String value, Function<List<Rule>, Rule> selectDefault) {
        Rule lastMatched = Optional.ofNullable(selectDefault).map(func -> (Rule)func.apply(rules)).orElse(DEFAULT_INCLUDE);
        for (Rule rule : rules) {
            if (!rule.matches(value)) continue;
            lastMatched = rule;
        }
        return lastMatched;
    }

    public static Rule lastMatch(List<Rule> rules, String value) {
        return Rules.lastMatch(rules, value, Rules::fuzzyDefaultInclude);
    }
}

