/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.util.Collection;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.ProgressCheck;
import net.adamcin.oakpal.api.ReportCollector;
import net.adamcin.oakpal.api.Severity;
import net.adamcin.oakpal.api.SimpleViolation;
import net.adamcin.oakpal.api.Violation;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class SimpleProgressCheck
implements ProgressCheck {
    protected final ReportCollector collector = new ReportCollector();
    private ResourceBundle resourceBundle;

    @Override
    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    @Nullable
    protected ResourceBundle getResourceBundle() throws MissingResourceException {
        if (this.resourceBundle == null && this.getResourceBundleBaseName() != null) {
            this.resourceBundle = Fun.result1(ResourceBundle::getBundle).apply(this.getResourceBundleBaseName()).getOrDefault(ResourceBundle.getBundle(SimpleProgressCheck.class.getName()));
        }
        return this.resourceBundle;
    }

    @NotNull
    protected String getString(@NotNull String key) {
        return Optional.ofNullable(this.getResourceBundle()).filter(bundle -> bundle.containsKey(key)).map(bundle -> bundle.getString(key)).orElse(key);
    }

    protected void reportViolation(Violation violation) {
        this.collector.reportViolation(violation);
    }

    protected final void reporting(@NotNull Consumer<SimpleViolation.Builder> customizer) {
        SimpleViolation.Builder builder = SimpleViolation.builder(this.getResourceBundle());
        customizer.accept(builder);
        this.reportViolation(builder.build());
    }

    protected final void reportViolation(Severity severity, String description, PackageId ... packages) {
        this.reporting(builder -> builder.withSeverity(severity).withDescription(description).withPackage(packages));
    }

    protected final void minorViolation(String description, PackageId ... packages) {
        this.reporting(builder -> builder.withSeverity(Severity.MINOR).withDescription(description).withPackage(packages));
    }

    protected final void majorViolation(String description, PackageId ... packages) {
        this.reporting(builder -> builder.withSeverity(Severity.MAJOR).withDescription(description).withPackage(packages));
    }

    protected final void severeViolation(String description, PackageId ... packages) {
        this.reporting(builder -> builder.withSeverity(Severity.SEVERE).withDescription(description).withPackage(packages));
    }

    @Override
    public void startedScan() {
        this.collector.clearViolations();
    }

    @Override
    public Collection<Violation> getReportedViolations() {
        return this.collector.getReportedViolations();
    }
}

