/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonCollectors;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.JsonArrayConvertible;
import net.adamcin.oakpal.api.JsonObjectConvertible;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

public final class JavaxJson {
    public static final Function<JsonValue, String> JSON_VALUE_STRING = Fun.compose1(JavaxJson::unwrap, Object::toString);

    private JavaxJson() {
    }

    public static boolean nonEmptyValue(@Nullable JsonValue value) {
        return !(value == null || value.getValueType() == JsonValue.ValueType.NULL || value.getValueType() == JsonValue.ValueType.ARRAY && value.asJsonArray().isEmpty() || value.getValueType() == JsonValue.ValueType.OBJECT && value.asJsonObject().isEmpty());
    }

    public static boolean nonDefaultValue(@Nullable JsonValue value, @NotNull JsonValue defaultValue) {
        return !defaultValue.equals(value);
    }

    public static JsonValue wrap(Object object) {
        if (object == null) {
            return JsonValue.NULL;
        }
        if (object instanceof JsonValue) {
            return (JsonValue)object;
        }
        if (object instanceof HasValue) {
            return ((HasValue)object).toValue().get();
        }
        if (object instanceof JsonObjectConvertible) {
            return ((JsonObjectConvertible)object).toJson();
        }
        if (object instanceof JsonArrayConvertible) {
            return ((JsonArrayConvertible)object).toJson();
        }
        if (object instanceof String) {
            return (JsonValue)Json.createArrayBuilder().add((String)object).build().get(0);
        }
        if (object instanceof Calendar) {
            return JavaxJson.wrap(ISO8601.format((Calendar)((Calendar)object)));
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (object instanceof Number) {
            if (object instanceof Integer) {
                return (JsonValue)Json.createArrayBuilder().add(((Integer)object).intValue()).build().get(0);
            }
            if (object instanceof Long) {
                return (JsonValue)Json.createArrayBuilder().add(((Long)object).longValue()).build().get(0);
            }
            if (object instanceof Double) {
                return (JsonValue)Json.createArrayBuilder().add(((Double)object).doubleValue()).build().get(0);
            }
            if (object instanceof BigInteger) {
                return (JsonValue)Json.createArrayBuilder().add((BigInteger)object).build().get(0);
            }
            if (object instanceof BigDecimal) {
                return (JsonValue)Json.createArrayBuilder().add((BigDecimal)object).build().get(0);
            }
            return (JsonValue)Json.createArrayBuilder().add(new BigDecimal(object.toString())).build().get(0);
        }
        if (object instanceof Object[]) {
            return (JsonValue)Arrays.stream((Object[])object).map(JavaxJson::wrap).collect(JsonCollectors.toJsonArray());
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
            if (object instanceof int[]) {
                return (JsonValue)Arrays.stream((int[])object).mapToObj(JavaxJson::wrap).collect(JsonCollectors.toJsonArray());
            }
            if (object instanceof long[]) {
                return (JsonValue)Arrays.stream((long[])object).mapToObj(JavaxJson::wrap).collect(JsonCollectors.toJsonArray());
            }
            if (object instanceof double[]) {
                return (JsonValue)Arrays.stream((double[])object).mapToObj(JavaxJson::wrap).collect(JsonCollectors.toJsonArray());
            }
            if (object instanceof char[]) {
                return JavaxJson.wrap(String.valueOf((char[])object));
            }
            if (object instanceof byte[]) {
                return JavaxJson.wrap(Base64.getUrlEncoder().encodeToString((byte[])object));
            }
            if (object instanceof float[]) {
                float[] floats = (float[])object;
                double[] doubles = new double[floats.length];
                for (int i = 0; i < floats.length; ++i) {
                    doubles[i] = floats[i];
                }
                return JavaxJson.wrap(doubles);
            }
            if (object instanceof boolean[]) {
                boolean[] booleans = (boolean[])object;
                Boolean[] boxed = new Boolean[booleans.length];
                for (int i = 0; i < booleans.length; ++i) {
                    boxed[i] = booleans[i];
                }
                return JavaxJson.wrap(boxed);
            }
        } else {
            if (object instanceof Map) {
                return (JsonValue)((Map)object).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> JavaxJson.wrap(entry.getValue()))).entrySet().stream().collect(JsonCollectors.toJsonObject());
            }
            if (object instanceof Collection) {
                return (JsonValue)((Collection)object).stream().map(JavaxJson::wrap).collect(JsonCollectors.toJsonArray());
            }
        }
        return (JsonValue)Json.createArrayBuilder().add(String.valueOf(object)).build().get(0);
    }

    public static Object unwrap(JsonValue jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        switch (jsonValue.getValueType()) {
            case STRING: {
                return ((JsonString)jsonValue).getString();
            }
            case NUMBER: {
                return ((JsonNumber)jsonValue).numberValue();
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                return JavaxJson.unwrapArray(jsonValue.asJsonArray());
            }
            case OBJECT: {
                return JavaxJson.unwrapObject(jsonValue.asJsonObject());
            }
        }
        return jsonValue == JsonValue.TRUE;
    }

    public static Map<String, Object> unwrapObject(JsonObject jsonObject) {
        return jsonObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JavaxJson.unwrap((JsonValue)entry.getValue())));
    }

    public static List<Object> unwrapArray(JsonArray jsonArray) {
        return jsonArray.getValuesAs(JavaxJson::unwrap);
    }

    @NotNull
    public static JsonObject shallowMergeObjects(@Nullable JsonObject base, @Nullable JsonObject overlay) {
        JsonObjectBuilder init = Json.createObjectBuilder();
        Optional.ofNullable(base).ifPresent(json -> json.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)init).add(arg_0, arg_1)));
        Optional.ofNullable(overlay).ifPresent(json -> json.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)init).add(arg_0, arg_1)));
        return init.build();
    }

    public static Value val(Object value) {
        if (value instanceof Cursor) {
            throw new IllegalArgumentException("dangling cursor for key: " + ((Cursor)value).getKey());
        }
        if (value instanceof HasValue) {
            return ((HasValue)value).toValue();
        }
        return new Value(value);
    }

    public static Obj obj(Key ... keys) {
        return new Obj(keys);
    }

    public static Obj obj(JsonObject jsonObject) {
        if (jsonObject != null) {
            return JavaxJson.obj(JavaxJson.unwrapObject(jsonObject));
        }
        return new Obj(new Key[0]);
    }

    public static Obj obj(Map<?, ?> map) {
        return new Obj(new Key[0]).and(map);
    }

    public static Key key(String key, Object value) {
        return new Key(key, value);
    }

    public static KeyCursor key(String key) {
        return new KeyCursor(key);
    }

    public static Arr arr(Object ... values) {
        if (values != null) {
            return new Arr(Arrays.asList(values));
        }
        return new Arr(Collections.emptyList());
    }

    public static Optional<JsonObject> optObject(JsonObject json, String key) {
        return Optional.ofNullable((JsonValue)json.get((Object)key)).filter(JsonObject.class::isInstance).map(JsonObject.class::cast);
    }

    public static JsonObject objectOrEmpty(JsonObject json, String key) {
        return JavaxJson.optObject(json, key).orElse(JsonValue.EMPTY_JSON_OBJECT);
    }

    public static Optional<JsonArray> optArray(JsonObject json, String key) {
        return Optional.ofNullable((JsonValue)json.get((Object)key)).filter(JsonArray.class::isInstance).map(JsonArray.class::cast);
    }

    public static JsonArray arrayOrEmpty(JsonObject json, String key) {
        return JavaxJson.optArray(json, key).orElse(JsonValue.EMPTY_JSON_ARRAY);
    }

    public static List<String> mapArrayOfStrings(JsonArray jsonArray) {
        return JavaxJson.mapArrayOfStrings(jsonArray, Function.identity());
    }

    public static <R> List<R> mapArrayOfStrings(JsonArray jsonArray, Function<String, R> mapFunction) {
        return JavaxJson.mapArrayOfStrings(jsonArray, mapFunction, false);
    }

    public static <R> List<R> mapArrayOfStrings(JsonArray jsonArray, Function<String, R> mapFunction, boolean discardNulls) {
        return Optional.ofNullable(jsonArray).orElse(JsonValue.EMPTY_JSON_ARRAY).stream().filter(JsonString.class::isInstance).map(mapFunction.compose(JsonString::getString).compose(JsonString.class::cast)).filter(discardNulls ? Objects::nonNull : elem -> true).collect(Collectors.toList());
    }

    public static <R> List<R> mapArrayOfObjects(JsonArray jsonArray, Function<JsonObject, R> mapFunction) {
        return JavaxJson.mapArrayOfObjects(jsonArray, mapFunction, false);
    }

    public static <R> List<R> mapArrayOfObjects(JsonArray jsonArray, Function<JsonObject, R> mapFunction, boolean discardNulls) {
        return Optional.ofNullable(jsonArray).orElse(JsonValue.EMPTY_JSON_ARRAY).stream().filter(value -> value.getValueType() == JsonValue.ValueType.OBJECT).map(JsonObject.class::cast).map(mapFunction).filter(discardNulls ? Objects::nonNull : elem -> true).collect(Collectors.toList());
    }

    public static <R> List<R> mapObjectValues(JsonObject jsonObject, BiFunction<String, JsonObject, R> mapBiFunction, boolean discardNulls) {
        return Optional.ofNullable(jsonObject).orElse(JsonValue.EMPTY_JSON_OBJECT).entrySet().stream().filter(Fun.testValue(value -> value.getValueType() == JsonValue.ValueType.OBJECT)).map(Fun.mapValue(JsonValue::asJsonObject)).map(Fun.mapEntry(mapBiFunction)).filter(discardNulls ? Objects::nonNull : elem -> true).collect(Collectors.toList());
    }

    public static <R> List<R> parseFromArray(@NotNull JsonArray jsonArray, @NotNull Fun.ThrowingFunction<String, R> parser, @Nullable BiConsumer<String, Exception> errorConsumer) {
        return jsonArray.stream().map(JSON_VALUE_STRING).flatMap(Fun.composeTry1(Stream::of, Stream::empty, parser, errorConsumer)).collect(Collectors.toList());
    }

    public static boolean hasNonNull(@NotNull JsonObject json, String key) {
        return json.containsKey((Object)key) && !json.isNull(key);
    }

    public static final class Arr
    implements HasValue,
    As<JsonArray> {
        final List<Value> values = new ArrayList<Value>();

        private Arr(List<Object> values) {
            if (values != null) {
                this.values.addAll(values.stream().map(JavaxJson::val).collect(Collectors.toList()));
            }
        }

        private Arr(Value initial) {
            this.values.add(JavaxJson.val(initial));
        }

        public Arr and(Object ... values) {
            if (values != null) {
                this.values.addAll(Arrays.stream(values).map(JavaxJson::val).collect(Collectors.toList()));
            }
            return this;
        }

        public Arr val(Object value) {
            this.values.add(JavaxJson.val(value));
            return this;
        }

        public Arr opt(Object value) {
            JsonValue wrapped = JavaxJson.wrap(value);
            if (JavaxJson.nonEmptyValue(wrapped)) {
                this.values.add(JavaxJson.val(wrapped));
            }
            return this;
        }

        public Arr opt(Object value, @NotNull Object ifNotValue) {
            JsonValue wrappedDefault;
            JsonValue wrapped = JavaxJson.wrap(value);
            if (JavaxJson.nonDefaultValue(wrapped, wrappedDefault = JavaxJson.wrap(ifNotValue))) {
                this.values.add(JavaxJson.val(wrapped));
            }
            return this;
        }

        @Override
        public JsonArray get() {
            JsonArrayBuilder arr = Json.createArrayBuilder();
            for (Value value : this.values) {
                arr.add(value.get());
            }
            return arr.build();
        }

        @Override
        public Value toValue() {
            return new Value(this.get());
        }
    }

    public static final class Obj
    implements HasValue,
    As<JsonObject> {
        final List<Key> entries = new ArrayList<Key>();

        private Obj(Key ... entries) {
            if (entries != null) {
                this.entries.addAll(Arrays.asList(entries));
            }
        }

        public Obj and(Key ... entries) {
            if (entries != null) {
                this.entries.addAll(Arrays.asList(entries));
            }
            return this;
        }

        public Obj and(Map<?, ?> map) {
            if (map != null) {
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    this.entries.add(new Key(String.valueOf(entry.getKey()), entry.getValue()));
                }
            }
            return this;
        }

        public ObjCursor key(String key) {
            return new ObjCursor(this, key);
        }

        public Obj key(String key, Object value) {
            this.entries.add(new Key(key, JavaxJson.val(value)));
            return this;
        }

        @Override
        public JsonObject get() {
            JsonObjectBuilder obj = Json.createObjectBuilder();
            for (Key entry : this.entries) {
                if (entry == null || entry.getKey() == null) continue;
                obj.add(entry.getKey(), entry.getValue().get());
            }
            return obj.build();
        }

        public Arr arrKeys() {
            return new Arr(this.entries.stream().map(Key::getKey).collect(Collectors.toList()));
        }

        public Arr arrVals() {
            return new Arr(this.entries.stream().map(Key::getValue).collect(Collectors.toList()));
        }

        @Override
        public Value toValue() {
            return new Value(this.get());
        }
    }

    public static final class Key
    implements HasValue,
    As<JsonObject> {
        private final String key;
        private final Value value;

        private Key(String key, Object value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.key = key;
            this.value = JavaxJson.val(value);
        }

        String getKey() {
            return this.key;
        }

        Value getValue() {
            return this.value;
        }

        public ObjCursor key(String key) {
            return new ObjCursor(new Obj(this), key);
        }

        public Obj key(String key, Object value) {
            return new Obj(this).key(key, value);
        }

        @Override
        public JsonObject get() {
            return new Obj(this).get();
        }

        @Override
        public Value toValue() {
            return new Obj(this).toValue();
        }
    }

    public static final class ObjCursor
    implements Cursor {
        private final Obj obj;
        private final String key;

        private ObjCursor(Obj obj, String key) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.obj = obj;
            this.key = key;
        }

        public Obj val(Object value) {
            return this.obj.key(this.key, value);
        }

        public Obj opt(Object value) {
            JsonValue wrapped = JavaxJson.wrap(value);
            if (JavaxJson.nonEmptyValue(wrapped)) {
                return this.obj.key(this.key, wrapped);
            }
            return this.obj;
        }

        public Obj opt(Object value, @NotNull Object ifNotValue) {
            JsonValue wrappedDefault;
            JsonValue wrapped = JavaxJson.wrap(value);
            if (JavaxJson.nonDefaultValue(wrapped, wrappedDefault = JavaxJson.wrap(ifNotValue))) {
                return this.obj.key(this.key, wrapped);
            }
            return this.obj;
        }

        public Obj getObj() {
            return this.obj;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    public static final class KeyCursor
    implements Cursor {
        private final String key;

        private KeyCursor(String key) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.key = key;
        }

        public Key val(Object value) {
            return JavaxJson.key(this.key, value);
        }

        public Obj opt(Object value) {
            JsonValue wrapped = JavaxJson.wrap(value);
            if (JavaxJson.nonEmptyValue(wrapped)) {
                return JavaxJson.obj(new Key[0]).key(this.key, wrapped);
            }
            return JavaxJson.obj(new Key[0]);
        }

        public Obj opt(Object value, @NotNull Object ifNotValue) {
            JsonValue wrappedDefault;
            JsonValue wrapped = JavaxJson.wrap(value);
            if (JavaxJson.nonDefaultValue(wrapped, wrappedDefault = JavaxJson.wrap(ifNotValue))) {
                return JavaxJson.obj(new Key[0]).key(this.key, wrapped);
            }
            return JavaxJson.obj(new Key[0]);
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    public static final class Value
    implements HasValue,
    As<JsonValue> {
        private final JsonValue value;

        private Value(Object value) {
            this.value = JavaxJson.wrap(value);
        }

        @Override
        public JsonValue get() {
            return this.value;
        }

        public Arr val(Object value) {
            return new Arr(this).val(value);
        }

        @Override
        public Value toValue() {
            return this;
        }
    }

    @ProviderType
    public static interface Cursor {
        public String getKey();
    }

    @ProviderType
    public static interface As<TYPE> {
        public TYPE get();
    }

    @ProviderType
    public static interface HasValue {
        public Value toValue();
    }
}

