/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.adamcin.oakpal.api.Fun;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public abstract class Result<V>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Result.class);

    private Result() {
    }

    @NotNull
    public abstract <W> Result<W> map(@NotNull Function<? super V, W> var1);

    @NotNull
    public abstract <W> Result<W> flatMap(@NotNull Function<? super V, Result<W>> var1);

    public abstract V getOrDefault(V var1);

    public abstract V getOrElse(@NotNull Supplier<? extends V> var1);

    public abstract Result<V> orElse(@NotNull Supplier<Result<V>> var1);

    public abstract Stream<V> stream();

    public abstract Result<V> teeLogError();

    public final boolean isSuccess() {
        return !this.isFailure();
    }

    public final boolean isFailure() {
        return this.getError().isPresent();
    }

    public final Optional<V> toOptional() {
        return this.stream().findFirst();
    }

    public abstract Optional<RuntimeException> getError();

    public final Optional<Throwable> findCause(@NotNull Predicate<? super Throwable> predicate) {
        return this.getError().map(Result::causing).orElse(Stream.empty()).filter(predicate).findFirst();
    }

    public final <E extends Throwable> Optional<E> findCause(@NotNull Class<E> errorType) {
        return this.findCause(errorType::isInstance).map(errorType::cast);
    }

    public final <E extends Exception> void throwCause(@NotNull Class<E> errorType) throws E {
        Optional<E> cause = this.findCause(errorType);
        if (cause.isPresent()) {
            throw (Exception)cause.get();
        }
    }

    static Stream<Throwable> causing(@NotNull Throwable caused) {
        return Stream.concat(Optional.of(caused).map(Stream::of).orElse(Stream.empty()), Optional.ofNullable(caused.getCause()).map(Result::causing).orElse(Stream.empty()));
    }

    public abstract void forEach(@NotNull Consumer<? super V> var1);

    public static <V> Result<V> failure(String message) {
        return new Failure(message);
    }

    public static <V> Result<V> failure(@NotNull Exception e) {
        return new Failure(e);
    }

    public static <V> Result<V> failure(@NotNull String message, @NotNull Exception e) {
        return new Failure(message, e);
    }

    public static <V> Result<V> failure(@NotNull RuntimeException e) {
        return new Failure(e);
    }

    public static <V> Result<V> success(V value) {
        return new Success<V>(value);
    }

    public static <V, R, A> Collector<Result<V>, Builder<V, A>, Result<R>> tryCollect(@NotNull Collector<V, A, R> collector) {
        Supplier<Builder> supplier = () -> new Builder(Result.success(collector.supplier().get()), collector.accumulator());
        BiConsumer<Builder, Result> accumulator = Builder::accept;
        BinaryOperator combiner = (builder0, builder1) -> new Builder(builder0.build().flatMap(left -> builder1.build().map(right -> collector.combiner().apply(left, right))), collector.accumulator());
        Function<Builder, Result> finisher = acc -> acc.build().map(collector.finisher());
        Collector.Characteristics[] characteristics = (Collector.Characteristics[])collector.characteristics().stream().filter(Fun.inSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.CONCURRENT)).negate()).toArray(Collector.Characteristics[]::new);
        return Collector.of(supplier, accumulator, combiner, finisher, characteristics);
    }

    public static <V> Collector<Result<V>, Stream.Builder<Result<V>>, Stream<Result<V>>> logAndRestream() {
        return new RestreamLogCollector(LOGGER, "");
    }

    public static <V> Collector<Result<V>, Stream.Builder<Result<V>>, Stream<Result<V>>> logAndRestream(@NotNull String message) {
        return new RestreamLogCollector(LOGGER, ": " + message);
    }

    static final class RestreamLogCollector<T>
    implements Collector<Result<T>, Stream.Builder<Result<T>>, Stream<Result<T>>> {
        final Supplier<Stream.Builder<Result<T>>> supplier;
        final BiConsumer<Stream.Builder<Result<T>>, Result<T>> accum;

        RestreamLogCollector(@NotNull Logger logger, @NotNull String collectorMessage) {
            if (logger.isDebugEnabled()) {
                Throwable creation = new Throwable();
                this.supplier = () -> {
                    logger.debug("result collector (see TRACE for creation stack)" + collectorMessage);
                    logger.trace("created here", creation);
                    return Stream.builder();
                };
                this.accum = (builder, element) -> builder.accept(element.teeLogError());
            } else {
                this.supplier = Stream::builder;
                this.accum = Stream.Builder::accept;
            }
        }

        @Override
        public Supplier<Stream.Builder<Result<T>>> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<Stream.Builder<Result<T>>, Result<T>> accumulator() {
            return this.accum;
        }

        @Override
        public BinaryOperator<Stream.Builder<Result<T>>> combiner() {
            return (left, right) -> {
                right.build().forEachOrdered(left);
                return left;
            };
        }

        @Override
        public Function<Stream.Builder<Result<T>>, Stream<Result<T>>> finisher() {
            return Stream.Builder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    public static final class Builder<V, A>
    implements Consumer<Result<V>> {
        final Result<A> resultAcc;
        final AtomicReference<Result<A>> latch;
        final BiConsumer<A, V> accumulator;

        Builder(@NotNull Result<A> initial, @NotNull BiConsumer<A, V> accumulator) {
            this.resultAcc = initial;
            this.latch = new AtomicReference<Result<A>>(this.resultAcc);
            this.accumulator = accumulator;
        }

        @Override
        public void accept(Result<V> valueResult) {
            this.latch.accumulateAndGet(this.resultAcc, (fromLatch, fromArg) -> fromLatch.flatMap(state -> valueResult.map(value -> {
                this.accumulator.accept(state, value);
                return state;
            })));
        }

        Result<A> build() {
            return this.latch.get();
        }
    }

    private static final class Success<V>
    extends Result<V> {
        private final V value;

        private Success(V value) {
            this.value = value;
        }

        @Override
        @NotNull
        public <W> Result<W> map(@NotNull Function<? super V, W> f) {
            return new Success<W>(f.apply(this.value));
        }

        @Override
        @NotNull
        public <W> Result<W> flatMap(@NotNull Function<? super V, Result<W>> f) {
            return f.apply(this.value);
        }

        @Override
        public V getOrDefault(V defaultValue) {
            return this.value;
        }

        @Override
        public V getOrElse(@NotNull Supplier<? extends V> defaultValue) {
            return this.value;
        }

        @Override
        public Result<V> orElse(@NotNull Supplier<Result<V>> defaultValue) {
            return this;
        }

        @Override
        public void forEach(@NotNull Consumer<? super V> consumer) {
            consumer.accept(this.value);
        }

        @Override
        public Stream<V> stream() {
            return this.value != null ? Stream.of(this.value) : Stream.empty();
        }

        @Override
        public Result<V> teeLogError() {
            return this;
        }

        @Override
        public Optional<RuntimeException> getError() {
            return Optional.empty();
        }

        public String toString() {
            return String.format("Success(%s)", String.valueOf(this.value));
        }
    }

    private static final class Failure<V>
    extends Result<V> {
        private final RuntimeException exception;

        private Failure(String message) {
            this.exception = new IllegalStateException(message);
        }

        private Failure(@NotNull RuntimeException e) {
            this.exception = e;
        }

        private Failure(@NotNull Exception e) {
            this.exception = new IllegalStateException(e.getMessage(), e);
        }

        private Failure(@NotNull String message, @NotNull Exception e) {
            this.exception = new IllegalStateException(message, e);
        }

        @Override
        @NotNull
        public <W> Result<W> map(@NotNull Function<? super V, W> f) {
            return new Failure<V>(this.exception);
        }

        @Override
        @NotNull
        public <W> Result<W> flatMap(@NotNull Function<? super V, Result<W>> f) {
            return new Failure<V>(this.exception);
        }

        @Override
        public V getOrDefault(V defaultValue) {
            this.logSupression();
            return defaultValue;
        }

        @Override
        public V getOrElse(@NotNull Supplier<? extends V> defaultValue) {
            this.logSupression();
            return defaultValue.get();
        }

        @Override
        public Result<V> orElse(@NotNull Supplier<Result<V>> defaultValue) {
            this.logSupression();
            return defaultValue.get();
        }

        @Override
        public void forEach(@NotNull Consumer<? super V> consumer) {
            this.logSupression();
        }

        @Override
        public Stream<V> stream() {
            this.logSupression();
            return Stream.empty();
        }

        @Override
        public Optional<RuntimeException> getError() {
            return Optional.of(this.exception);
        }

        public String toString() {
            return String.format("Failure(%s)", this.exception.getMessage());
        }

        @Override
        public Result<V> teeLogError() {
            LOGGER.debug("failure [stacktrace visible in TRACE logging]: {}", (Object)this);
            this.logTrace();
            return this;
        }

        private void logTrace() {
            LOGGER.trace("thrown:", (Throwable)this.exception);
        }

        private void logSupression() {
            LOGGER.debug("failure (suppressed) [stacktrace visible in TRACE logging]: {}", (Object)this);
            this.logTrace();
        }
    }
}

