/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.json.JsonObject;
import net.adamcin.oakpal.api.ApiConstants;
import net.adamcin.oakpal.api.JavaxJson;
import net.adamcin.oakpal.api.Severity;
import net.adamcin.oakpal.api.Violation;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.jetbrains.annotations.Nullable;

public final class SimpleViolation
implements Violation {
    private final Severity severity;
    private final String description;
    private final List<PackageId> packages;

    public SimpleViolation(Severity severity, String description, PackageId ... packages) {
        this(severity, description, packages != null ? Arrays.asList(packages) : null);
    }

    public SimpleViolation(Severity severity, String description, List<PackageId> packages) {
        this.severity = severity != null ? severity : Severity.MAJOR;
        this.description = description;
        this.packages = packages == null || packages.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PackageId>(packages));
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(ResourceBundle resourceBundle) {
        return new Builder(resourceBundle);
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public Collection<PackageId> getPackages() {
        return this.packages;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static SimpleViolation fromReported(Violation violation) {
        Severity severity = violation.getSeverity();
        String description = violation.getDescription();
        ArrayList<PackageId> packages = new ArrayList<PackageId>(violation.getPackages());
        return new SimpleViolation(severity, description, packages);
    }

    public static SimpleViolation fromJson(JsonObject jsonViolation) {
        String vSeverity = jsonViolation.getString(ApiConstants.violationKeys().severity(), Severity.MINOR.name());
        Severity severity = Severity.valueOf(vSeverity);
        String description = jsonViolation.getString(ApiConstants.violationKeys().description(), "");
        List packages = JavaxJson.optArray(jsonViolation, ApiConstants.violationKeys().packages()).map(array -> JavaxJson.mapArrayOfStrings(array, PackageId::fromString, true)).orElseGet(Collections::emptyList);
        return new SimpleViolation(severity, description, packages);
    }

    public String toString() {
        return "SimpleViolation{severity=" + this.severity + ", description='" + this.description + "', packages=" + this.packages + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleViolation that = (SimpleViolation)o;
        return this.severity == that.severity && Objects.equals(this.description, that.description) && this.packages.equals(that.packages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.description, this.packages});
    }

    public static final class Builder {
        @Nullable
        private final ResourceBundle resourceBundle;
        private Severity severity;
        private String description;
        private List<Object> arguments = new ArrayList<Object>();
        private List<PackageId> packages = new ArrayList<PackageId>();

        private Builder(@Nullable ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public Builder withSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withArguments(List<Object> arguments) {
            this.arguments = arguments != null ? new ArrayList<Object>(arguments) : new ArrayList();
            return this;
        }

        public Builder withArgument(Object ... argument) {
            if (argument != null) {
                this.arguments.addAll(Arrays.asList(argument));
            }
            return this;
        }

        public Builder withPackages(List<PackageId> packages) {
            this.packages = packages != null ? new ArrayList<PackageId>(packages) : new ArrayList();
            return this;
        }

        public Builder withPackage(PackageId ... packageId) {
            if (packageId != null) {
                this.packages.addAll(Arrays.asList(packageId));
            }
            return this;
        }

        public SimpleViolation build() {
            String localDescription;
            String string = localDescription = this.description != null && this.resourceBundle != null && this.resourceBundle.containsKey(this.description) ? this.resourceBundle.getString(this.description) : this.description;
            if (localDescription == null || this.arguments == null || this.arguments.isEmpty()) {
                return new SimpleViolation(this.severity, localDescription, this.packages);
            }
            return new SimpleViolation(this.severity, MessageFormat.format(localDescription, this.arguments.toArray(new Object[this.arguments.size()])), this.packages);
        }
    }
}

