/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.testing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestPackageUtil {
    private static final Logger log = LoggerFactory.getLogger(TestPackageUtil.class);
    private static final Properties properties = new Properties();
    private static String testPackagesSrc;
    static final String PN_TEST_PACKAGES_SRC = "test-packages.src";
    static final String PN_TEST_PACKAGES_ROOT = "test-packages.root";
    private static Path testPackagesRoot;
    static final IOFileFilter includedEntry;

    private TestPackageUtil() {
    }

    static void loadPropertiesFromResource(@NotNull Properties props, @NotNull String resourceName) {
        block15: {
            try (InputStream propsIn = TestPackageUtil.class.getResourceAsStream(resourceName);){
                if (propsIn != null) {
                    props.load(propsIn);
                    break block15;
                }
                throw new IOException("failed to open stream from resource: " + resourceName);
            }
            catch (IOException e) {
                log.error("Failed to load properties from " + resourceName + " (see cause in DEBUG)");
                log.debug("Failed to load properties from " + resourceName, (Throwable)e);
            }
        }
    }

    public static File prepareTestPackage(String filename) throws IOException {
        File file = new File(testPackagesRoot.toFile(), filename);
        try (InputStream is = TestPackageUtil.class.getResourceAsStream(testPackagesSrc + filename);
             FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        return file;
    }

    public static File prepareTestPackageFromFolder(@NotNull String filename, @NotNull File srcFolder) throws IOException {
        File absFile = srcFolder.getAbsoluteFile();
        if (!absFile.isDirectory()) {
            throw new IOException("expected directory in srcFolder parameter for test package filename " + filename + ", srcFolder exists " + srcFolder);
        }
        File file = new File(testPackagesRoot.toFile(), filename);
        TestPackageUtil.buildJarFromDir(absFile, file.getAbsoluteFile(), Collections.emptyMap());
        return file;
    }

    static void buildJarOutputStreamFromDir(@NotNull File srcDir, @NotNull JarOutputStream jos, @NotNull Map<String, File> additionalEntries) throws IOException {
        String absPath = srcDir.getAbsolutePath();
        for (File file : FileUtils.listFilesAndDirs((File)srcDir, (IOFileFilter)includedEntry, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            JarEntry entry;
            String filePath = file.getAbsolutePath();
            String entryName = filePath.substring(absPath.length()).replaceFirst("^" + Pattern.quote(File.separator) + "?", "").replace(File.separator, "/");
            if (entryName.isEmpty()) continue;
            if (file.isDirectory()) {
                entry = new JarEntry(entryName + "/");
                entry.setTime(file.lastModified());
                jos.putNextEntry(entry);
            } else {
                entry = new JarEntry(entryName);
                entry.setTime(file.lastModified());
                jos.putNextEntry(entry);
                try (FileInputStream fileInput = new FileInputStream(file);){
                    IOUtils.copy((InputStream)fileInput, (OutputStream)jos);
                }
            }
            jos.closeEntry();
        }
        for (Map.Entry entry : additionalEntries.entrySet()) {
            JarEntry entry2;
            String entryName = (String)entry.getKey();
            if (entryName.isEmpty()) continue;
            if (((File)entry.getValue()).isDirectory()) {
                entry2 = new JarEntry(entryName.replaceFirst("/?$", "/"));
                entry2.setTime(((File)entry.getValue()).lastModified());
                jos.putNextEntry(entry2);
            } else {
                entry2 = new JarEntry(entryName.replaceFirst("/?$", ""));
                entry2.setTime(((File)entry.getValue()).lastModified());
                jos.putNextEntry(entry2);
                try (FileInputStream fileInput = new FileInputStream((File)entry.getValue());){
                    IOUtils.copy((InputStream)fileInput, (OutputStream)jos);
                }
            }
            jos.closeEntry();
        }
    }

    public static void buildJarFromDir(@NotNull File srcDir, @NotNull File targetJar, @NotNull Map<String, File> additionalEntries) throws IOException {
        block39: {
            if (!targetJar.exists()) {
                File targetDir = targetJar.getParentFile();
                if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
                    throw new IOException("failed to create parent target directory: " + targetDir.getAbsolutePath());
                }
                File manifestFile = new File(srcDir, "META-INF/MANIFEST.MF");
                if (manifestFile.exists()) {
                    try (FileInputStream manIn = new FileInputStream(manifestFile);){
                        Manifest man = new Manifest(manIn);
                        try (JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(targetJar), man);){
                            TestPackageUtil.buildJarOutputStreamFromDir(srcDir, jos, additionalEntries);
                            break block39;
                        }
                    }
                }
                try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(targetJar));){
                    TestPackageUtil.buildJarOutputStreamFromDir(srcDir, jos, additionalEntries);
                }
            }
        }
    }

    static {
        TestPackageUtil.loadPropertiesFromResource(properties, "/test-packages.properties");
        testPackagesSrc = properties.getProperty(PN_TEST_PACKAGES_SRC, "/oakpal-testing/test-packages/");
        testPackagesRoot = Paths.get(properties.getProperty(PN_TEST_PACKAGES_ROOT, "target").replaceAll("/test-packages$", ""), new String[0]).resolve("test-packages");
        testPackagesRoot.toFile().mkdirs();
        includedEntry = new IOFileFilter(){

            public boolean accept(File file) {
                return !"META-INF".equals(file.getParentFile().getName()) || !"MANIFEST.MF".equals(file.getName());
            }

            public boolean accept(File dir, String name) {
                return !"META-INF".equals(dir.getName()) || !"MANIFEST.MF".equals(name);
            }
        };
    }
}

