/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonCollectors;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.JavaxJson;
import net.adamcin.oakpal.api.Result;
import net.adamcin.oakpal.api.Rule;
import net.adamcin.oakpal.api.Rules;
import net.adamcin.oakpal.core.Checklist;
import net.adamcin.oakpal.core.ForcedRoot;
import net.adamcin.oakpal.core.JcrNs;
import net.adamcin.oakpal.core.JsonCnd;
import net.adamcin.oakpal.core.NamespaceMappingRequest;
import net.adamcin.oakpal.webster.CndExporter;
import net.adamcin.oakpal.webster.QName;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChecklistExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChecklistExporter.class);
    private final List<Op> operations;
    private final List<String> exportTypeDefs;
    private final List<Rule> pathScopes;
    private final List<Rule> nodeTypeFilters;
    private final List<JcrNs> jcrNamespaces;
    public static final ForcedRootUpdatePolicy DEFAULT_UPDATE_POLICY = ForcedRootUpdatePolicy.REPLACE;
    public static final String COVARIANT_PREFIX = "+";
    static final Predicate<String> COVARIANT_FILTER = name -> name.startsWith(COVARIANT_PREFIX);
    static final Function<String, String> COVARIANT_FORMAT = name -> name.substring(COVARIANT_PREFIX.length());

    private ChecklistExporter(List<Op> operations, List<String> exportTypeDefs, List<Rule> pathScopes, List<Rule> nodeTypeFilters, List<JcrNs> jcrNamespaces) {
        this.operations = operations;
        this.exportTypeDefs = exportTypeDefs;
        this.pathScopes = pathScopes;
        this.nodeTypeFilters = nodeTypeFilters;
        this.jcrNamespaces = jcrNamespaces;
    }

    static void ensureNamespaces(@NotNull Session session, @NotNull NamespaceMapping namespaces) throws RepositoryException {
        NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
        List<String> registered = Arrays.asList(registry.getURIs());
        namespaces.getURIToPrefixMapping().entrySet().stream().filter(entry -> !((String)entry.getKey()).isEmpty() && !((String)entry.getValue()).isEmpty()).forEachOrdered(Fun.uncheckVoid1(entry -> {
            if (registered.contains(entry.getKey())) {
                session.setNamespacePrefix((String)entry.getValue(), (String)entry.getKey());
            } else {
                registry.registerNamespace((String)entry.getValue(), (String)entry.getKey());
            }
        }));
    }

    static Set<String> findJcrPrefixesInForcedRoot(@NotNull Set<String> acc, @NotNull ForcedRoot forcedRoot) {
        acc.addAll(Arrays.asList(forcedRoot.getNamespacePrefixes()));
        return acc;
    }

    static Set<String> findNodeTypesInForcedRoot(Set<String> acc, ForcedRoot forcedRoot) {
        Optional.ofNullable(forcedRoot.getPrimaryType()).ifPresent(acc::add);
        Optional.ofNullable(forcedRoot.getMixinTypes()).ifPresent(acc::addAll);
        return acc;
    }

    static <U> BinaryOperator<U> preferDifferent(@NotNull U value) {
        return (left, right) -> left.equals(value) ? right : left;
    }

    static Function<String, String> nsRemapName(NamespaceMapping fromMapping, NamespaceMapping toMapping) {
        Map fromUris = fromMapping.getURIToPrefixMapping();
        Map toUris = toMapping.getURIToPrefixMapping();
        HashSet allUris = new HashSet(fromUris.keySet());
        allUris.addAll(toUris.keySet());
        HashMap<String, Pattern> prefixToPrefix = new HashMap<String, Pattern>();
        for (String uri : allUris) {
            String toPrefix;
            String fromPrefix = (String)fromUris.getOrDefault(uri, toUris.get(uri));
            if (fromPrefix.equals(toPrefix = (String)toUris.getOrDefault(uri, fromUris.get(uri)))) continue;
            prefixToPrefix.put(toPrefix, Pattern.compile("(?<=^|/)" + Pattern.quote(fromPrefix) + "(?=:)"));
        }
        return value -> prefixToPrefix.entrySet().stream().reduce(value, (input, entry) -> ((Pattern)entry.getValue()).matcher((CharSequence)input).replaceAll((String)entry.getKey()), ChecklistExporter.preferDifferent(value));
    }

    static Function<ForcedRoot, ForcedRoot> nsRemapForcedRoot(NamespaceMapping fromMapping, NamespaceMapping toMapping) {
        Function<String, String> replacer = ChecklistExporter.nsRemapName(fromMapping, toMapping);
        return orig -> {
            ForcedRoot root = new ForcedRoot();
            Optional.ofNullable(orig.getPath()).map(replacer).ifPresent(arg_0 -> ((ForcedRoot)root).setPath(arg_0));
            Optional.ofNullable(orig.getPrimaryType()).map(replacer).ifPresent(arg_0 -> ((ForcedRoot)root).setPrimaryType(arg_0));
            Optional.ofNullable(orig.getMixinTypes()).map(mixins -> mixins.stream().map(replacer).collect(Collectors.toList())).ifPresent(arg_0 -> ((ForcedRoot)root).setMixinTypes(arg_0));
            return root;
        };
    }

    Predicate<ForcedRoot> getRetainFilter(ForcedRootUpdatePolicy updatePolicy) {
        switch (updatePolicy != null ? updatePolicy : DEFAULT_UPDATE_POLICY) {
            case TRUNCATE: {
                return root -> false;
            }
            case REPLACE: {
                return root -> Rules.lastMatch(this.pathScopes, (String)root.getPath()).isExclude();
            }
        }
        return root -> true;
    }

    BiPredicate<NamePathResolver, NodeType> exportTypeDefSelector() {
        Set singleTypes = this.exportTypeDefs.stream().filter(COVARIANT_FILTER.negate()).collect(Collectors.toSet());
        Set superTypes = this.exportTypeDefs.stream().filter(COVARIANT_FILTER).map(COVARIANT_FORMAT).collect(Collectors.toSet());
        return (resolver, type) -> {
            String name = type.getName();
            if (!Rules.lastMatch(this.nodeTypeFilters, (String)name).isInclude()) return false;
            if (singleTypes.contains(name)) return true;
            if (!Stream.of(type.getSupertypes()).map(NodeTypeDefinition::getName).anyMatch(superTypes::contains)) return false;
            return true;
        };
    }

    public void updateChecklist(WriterOpener writerOpener, Session session, Checklist checklist, ForcedRootUpdatePolicy updatePolicy) throws IOException, RepositoryException {
        ArrayList chkNs = new ArrayList();
        if (checklist != null && checklist.getJcrNamespaces() != null) {
            chkNs.addAll(checklist.getJcrNamespaces());
        }
        NamespaceMapping origMapping = JsonCnd.toNamespaceMapping(chkNs);
        NamespaceMapping remapping = JsonCnd.toNamespaceMapping(this.jcrNamespaces);
        ChecklistExporter.ensureNamespaces(session, origMapping);
        ChecklistExporter.ensureNamespaces(session, remapping);
        List<ForcedRoot> newRoots = this.findRoots(session);
        Predicate<ForcedRoot> retainFilter = this.getRetainFilter(updatePolicy);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        LinkedHashMap existing = new LinkedHashMap();
        ArrayList privileges = new ArrayList();
        if (checklist != null) {
            checklist.toJson().forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
            privileges.addAll(checklist.getJcrPrivileges());
            checklist.getForcedRoots().stream().map(ChecklistExporter.nsRemapForcedRoot(origMapping, remapping)).filter(retainFilter).forEachOrdered(root -> existing.put(root.getPath(), root));
        }
        NamespaceMappingRequest.Builder request = new NamespaceMappingRequest.Builder();
        if (!privileges.isEmpty()) {
            builder.add(Checklist.keys().jcrPrivileges(), JsonCnd.privilegesToJson(privileges, (NamespaceMapping)origMapping));
            privileges.stream().flatMap(JsonCnd::namedBy).forEach(arg_0 -> ((NamespaceMappingRequest.Builder)request).withQName(arg_0));
        }
        newRoots.forEach(root -> existing.put(root.getPath(), root));
        ArrayList forcedRoots = new ArrayList(existing.values());
        Collections.sort(forcedRoots);
        JsonArray forcedRootsJson = (JsonArray)forcedRoots.stream().map(ForcedRoot::toJson).collect(JsonCollectors.toJsonArray());
        builder.add(Checklist.keys().forcedRoots(), (JsonValue)forcedRootsJson);
        DefaultNamePathResolver resolver = new DefaultNamePathResolver(session);
        Set builtinNodetypes = CndExporter.BUILTIN_NODETYPES.stream().map(Fun.uncheck1(arg_0 -> ((NamePathResolver)resolver).getQName(arg_0))).filter(Objects::nonNull).collect(Collectors.toSet());
        List<Name> foundNodeTypes = forcedRoots.stream().reduce(new HashSet(), ChecklistExporter::findNodeTypesInForcedRoot, ChecklistExporter.addToLeft()).stream().map(Fun.uncheck1(arg_0 -> ((NamePathResolver)resolver).getQName(arg_0))).collect(Collectors.toList());
        Map<Name, NodeTypeDefinition> exportedNodeTypes = CndExporter.retrieveNodeTypes(session, foundNodeTypes, this.exportTypeDefSelector());
        List qNodeTypes = exportedNodeTypes.entrySet().stream().map(Fun.mapValue((Function)JsonCnd.adaptToQ((Session)session))).filter(Fun.testKey(((Predicate<Name>)builtinNodetypes::contains).negate())).map(Map.Entry::getValue).collect(Collectors.toList());
        NamespaceMapping spm = new NamespaceMapping((NamespaceResolver)new SessionNamespaceResolver(session));
        if (!qNodeTypes.isEmpty()) {
            Set nsUris = qNodeTypes.stream().flatMap(JsonCnd::namedBy).map(Name::getNamespaceURI).collect(Collectors.toSet());
            Map uriMapping = remapping.getURIToPrefixMapping();
            nsUris.forEach(Fun.uncheckVoid1(uri -> {
                String prefix = uriMapping.containsKey(uri) ? (String)uriMapping.get(uri) : spm.getPrefix(uri);
                request.withRetainPrefix(prefix);
                spm.setMapping(prefix, uri);
            }));
            JsonObject jcrNodetypes = JsonCnd.toJson(qNodeTypes, (NamespaceMapping)new NamespaceMapping((NamespaceResolver)new SessionNamespaceResolver(session)));
            builder.add(Checklist.keys().jcrNodetypes(), (JsonValue)jcrNodetypes);
        }
        Set forcedRootPrefixes = forcedRoots.stream().reduce(new HashSet(), ChecklistExporter::findJcrPrefixesInForcedRoot, ChecklistExporter.addToLeft());
        forcedRootPrefixes.forEach(arg_0 -> ((NamespaceMappingRequest.Builder)request).withRetainPrefix(arg_0));
        List exportNamespaces = request.build().resolveToJcrNs(spm).stream().flatMap(Result::stream).collect(Collectors.toList());
        if (!exportNamespaces.isEmpty()) {
            builder.add(Checklist.keys().jcrNamespaces(), JavaxJson.wrap(exportNamespaces));
        }
        JsonObject sorted = (JsonObject)builder.build().entrySet().stream().sorted(Checklist.comparingJsonKeys(Map.Entry::getKey)).collect(JsonCollectors.toJsonObject());
        try (Writer writer = writerOpener.open();
             JsonWriter jsonWriter = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true)).createWriter(writer);){
            jsonWriter.writeObject(sorted);
        }
    }

    static <E, U extends Collection<E>> BinaryOperator<U> addToLeft() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    public List<ForcedRoot> findRoots(Session session) throws RepositoryException {
        ArrayList<ForcedRoot> roots = new ArrayList<ForcedRoot>();
        block4: for (Op op : this.operations) {
            switch (op.selectorType) {
                case PATH: {
                    roots.addAll(this.traverse(session, op.args));
                    continue block4;
                }
                case NODETYPE: {
                    roots.addAll(this.query(session, this.ntStatement(session, op.args)));
                    continue block4;
                }
            }
            roots.addAll(this.query(session, (String)op.args.get(0)));
        }
        return roots;
    }

    String ntStatement(Session session, List<String> nodeTypeNames) throws RepositoryException {
        ArrayList subqueries = new ArrayList();
        NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
        nodeTypeNames.stream().filter(COVARIANT_FILTER).map(COVARIANT_FORMAT).filter(Fun.testOrDefault1(arg_0 -> ((NodeTypeManager)ntManager).hasNodeType(arg_0), (boolean)false)).map(name -> String.format("SELECT [jcr:path] FROM [%s] AS a", name)).forEachOrdered(subqueries::add);
        nodeTypeNames.stream().filter(COVARIANT_FILTER.negate()).filter(Fun.testOrDefault1(arg_0 -> ((NodeTypeManager)ntManager).hasNodeType(arg_0), (boolean)false)).map(name -> String.format("SELECT [jcr:path] FROM [nt:base] AS a WHERE [a].[jcr:primaryType] = '%s' UNION SELECT [jcr:path] FROM [nt:base] AS a WHERE [a].[jcr:mixinTypes] = '%s'", name, name)).forEachOrdered(subqueries::add);
        return String.join((CharSequence)" UNION ", subqueries) + " OPTION(TRAVERSAL OK, INDEX NAME nodetype)";
    }

    List<ForcedRoot> query(Session session, String statement) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        NamespaceMapping mapping = new NamespaceMapping((NamespaceResolver)new SessionNamespaceResolver(session));
        String language = statement.toUpperCase().replaceFirst("^\\s*((MEASURE|EXPLAIN)\\s*)*", "").startsWith("SELECT") ? "JCR-SQL2" : "xpath";
        Query query = qm.createQuery(statement, language);
        QueryResult result = query.execute();
        LinkedHashMap roots = new LinkedHashMap();
        NodeIterator nodes = result.getNodes();
        while (nodes.hasNext()) {
            this.nodeToRoot(nodes.nextNode(), mapping).ifPresent(root -> roots.put(root.getPath(), root));
        }
        return new ArrayList<ForcedRoot>(roots.values());
    }

    List<ForcedRoot> traverse(Session session, List<String> paths) throws RepositoryException {
        ArrayList<ForcedRoot> roots = new ArrayList<ForcedRoot>();
        NamespaceMapping mapping = new NamespaceMapping((NamespaceResolver)new SessionNamespaceResolver(session));
        for (String path : paths) {
            if (!session.nodeExists(path)) continue;
            this.nodeToRoot(session.getNode(path), mapping).ifPresent(roots::add);
        }
        return roots;
    }

    Optional<ForcedRoot> nodeToRoot(Node node, NamespaceMapping mapping) throws RepositoryException {
        if (Rules.lastMatch(this.pathScopes, (String)node.getPath()).isExclude()) {
            return Optional.empty();
        }
        ForcedRoot forcedRoot = new ForcedRoot();
        forcedRoot.setPath(node.getPath());
        String primaryType = node.getPrimaryNodeType().getName();
        if (Rules.lastMatch(this.nodeTypeFilters, (String)QName.parseQName(mapping, QName.Type.NODETYPE, primaryType).toString()).isInclude()) {
            forcedRoot.setPrimaryType(primaryType);
        }
        List mixinTypes = Stream.of(node.getMixinNodeTypes()).map(Fun.compose1(NodeTypeDefinition::getName, qName -> QName.parseQName(mapping, QName.Type.NODETYPE, qName).toString())).filter(name -> Rules.lastMatch(this.nodeTypeFilters, (String)name).isInclude()).collect(Collectors.toList());
        forcedRoot.setMixinTypes(mixinTypes);
        return Optional.of(forcedRoot);
    }

    @FunctionalInterface
    public static interface WriterOpener {
        @NotNull
        public Writer open() throws IOException;
    }

    public static enum ForcedRootUpdatePolicy {
        TRUNCATE,
        REPLACE,
        MERGE;


        public static ForcedRootUpdatePolicy byName(String name) {
            for (ForcedRootUpdatePolicy value : ForcedRootUpdatePolicy.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown policy name: " + name);
        }
    }

    static final class Op {
        private final SelectorType selectorType;
        private final List<String> args;

        Op(@NotNull SelectorType selectorType, String ... args) {
            this.selectorType = selectorType;
            this.args = Arrays.asList(args);
        }

        public String toString() {
            return String.format("%s: %s", this.selectorType.name(), this.args);
        }
    }

    public static enum SelectorType {
        QUERY,
        PATH,
        NODETYPE;


        public static SelectorType byName(String name) {
            for (SelectorType value : SelectorType.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown selector type: " + name);
        }
    }

    public static final class Builder {
        private List<Op> operations = new ArrayList<Op>();
        private List<String> exportTypeDefs = new ArrayList<String>();
        private List<Rule> pathScopes = new ArrayList<Rule>();
        private List<Rule> nodeTypeFilters = new ArrayList<Rule>();
        private List<JcrNs> nsMapping = new ArrayList<JcrNs>();

        public Builder byPath(String ... paths) {
            LOGGER.debug("[byPath] paths={}", (Object)Arrays.toString(paths));
            this.operations.add(new Op(SelectorType.PATH, paths));
            return this;
        }

        public Builder byQuery(String statement) {
            LOGGER.debug("[byQuery] statement={}", (Object)statement);
            this.operations.add(new Op(SelectorType.QUERY, statement));
            return this;
        }

        public Builder byNodeType(String ... nodeTypes) {
            LOGGER.debug("[byNodeType] nodeTypes={}", (Object)Arrays.toString(nodeTypes));
            this.operations.add(new Op(SelectorType.NODETYPE, nodeTypes));
            this.exportTypeDefs.addAll(Arrays.asList(nodeTypes));
            return this;
        }

        public Builder withScopePaths(List<Rule> scopePaths) {
            this.pathScopes = Optional.ofNullable(scopePaths).orElse(Collections.emptyList());
            return this;
        }

        public Builder withNodeTypeFilters(List<Rule> nodeTypeFilters) {
            this.nodeTypeFilters = Optional.ofNullable(nodeTypeFilters).orElse(Collections.emptyList());
            return this;
        }

        public Builder withJcrNamespaces(List<JcrNs> jcrNamespaces) {
            this.nsMapping = jcrNamespaces;
            return this;
        }

        public Builder withExportNodeTypes(List<String> exportNodeTypes) {
            Optional.ofNullable(exportNodeTypes).ifPresent(this.exportTypeDefs::addAll);
            return this;
        }

        public ChecklistExporter build() {
            return new ChecklistExporter(this.operations, this.exportTypeDefs, this.pathScopes, this.nodeTypeFilters, this.nsMapping);
        }
    }
}

