/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeTemplate;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.Result;
import net.adamcin.oakpal.api.Rule;
import net.adamcin.oakpal.api.Rules;
import net.adamcin.oakpal.core.JsonCnd;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.commons.cnd.TemplateBuilderFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.compact.CompactNodeTypeDefWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CndExporter {
    private final List<Rule> scopeExportNames;
    private final List<Rule> scopeReplaceNames;
    private final boolean includeBuiltins;
    public static final List<String> BUILTIN_NODETYPES = JsonCnd.BUILTIN_NODETYPES;

    private CndExporter(List<Rule> scopeExportNames, List<Rule> scopeReplaceNames, boolean includeBuiltins) {
        this.scopeExportNames = scopeExportNames != null ? scopeExportNames : Collections.emptyList();
        this.scopeReplaceNames = scopeReplaceNames != null ? scopeReplaceNames : Collections.emptyList();
        this.includeBuiltins = includeBuiltins;
    }

    public void writeNodetypes(@NotNull File cndFile, @NotNull Session session, @NotNull List<String> desiredTypeNames) throws RepositoryException, IOException, ParseException {
        this.writeNodetypes(() -> new OutputStreamWriter((OutputStream)new FileOutputStream(cndFile), StandardCharsets.UTF_8), session, desiredTypeNames, cndFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNodetypes(@NotNull WriterOpener writerOpener, @NotNull Session session, @NotNull List<String> desiredTypeNames, @Nullable File initialCnd) throws RepositoryException, IOException, ParseException {
        DefaultNamePathResolver resolver = new DefaultNamePathResolver(session);
        TemplateBuilderFactory defFactory = new TemplateBuilderFactory(session);
        List resolvedUris = desiredTypeNames.stream().flatMap(JsonCnd::streamNsPrefix).collect(Collectors.toSet()).stream().map(Fun.result1(arg_0 -> ((Session)session).getNamespaceURI(arg_0))).collect(Collectors.toList());
        CndExporter.combineCauseMessages(resolvedUris.stream(), NamespaceException.class, RepositoryException.class);
        Function mapper = Fun.tryOrDefault1(arg_0 -> ((NamePathResolver)resolver).getQName(arg_0), null);
        Function qualifier = Fun.tryOrDefault1(arg_0 -> ((NamePathResolver)resolver).getJCRName(arg_0), null);
        HashSet<Name> exportTypeNames = new HashSet<Name>();
        desiredTypeNames.stream().map(mapper).filter(Objects::nonNull).forEachOrdered(exportTypeNames::add);
        LinkedHashMap<Name, NodeTypeTemplate> writableTypes = new LinkedHashMap<Name, NodeTypeTemplate>();
        if (initialCnd != null && initialCnd.isFile()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(initialCnd), StandardCharsets.UTF_8);){
                CompactNodeTypeDefReader ntReader = new CompactNodeTypeDefReader((Reader)reader, initialCnd.toURI().toString(), (DefinitionBuilderFactory)defFactory);
                for (NodeTypeTemplate def : ntReader.getNodeTypeDefinitions()) {
                    Name defName = (Name)mapper.apply(def.getName());
                    writableTypes.put(defName, def);
                }
            }
        }
        Set builtinNodetypes = BUILTIN_NODETYPES.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toSet());
        Function normalizer = Fun.compose1((Function)mapper, (Function)qualifier);
        Predicate scopeExportFilter = Fun.composeTest1((Function)Fun.compose1(NodeTypeDefinition::getName, (Function)normalizer), name -> Rules.lastMatch(this.scopeExportNames, (String)name).isInclude());
        Predicate<String> scopeReplaceMatcher = name -> Rules.lastMatch(this.scopeReplaceNames, (String)name).isInclude();
        Predicate scopeReplaceFilter = Fun.composeTest1((Function)Fun.compose1(NodeTypeDefinition::getName, (Function)normalizer), scopeReplaceMatcher);
        Predicate addOrReplaceFilter = Fun.composeTest1((Function)Fun.compose1(NodeTypeDefinition::getName, (Function)mapper), (Predicate)Fun.inSet(writableTypes.keySet())).negate().or(scopeReplaceFilter);
        Predicate<Name> builtinMatcher = this.includeBuiltins ? name -> true : Fun.inSet(builtinNodetypes).negate();
        Predicate builtinFilter = Fun.composeTest1((Function)Fun.compose1(NodeTypeDefinition::getName, (Function)mapper), builtinMatcher);
        writableTypes.values().stream().map(NodeTypeTemplate.class::cast).flatMap(CndExporter::ntDepStream).map(mapper).filter(Objects::nonNull).filter(Fun.inSet(writableTypes.keySet()).negate()).filter(builtinMatcher).forEachOrdered(exportTypeNames::add);
        Predicate includeFilter = builtinFilter.and(scopeExportFilter).and(addOrReplaceFilter);
        Map<Name, NodeTypeDefinition> exportedTypes = CndExporter.retrieveNodeTypes(session, exportTypeNames);
        exportedTypes.values().stream().filter(includeFilter).forEachOrdered(type -> writableTypes.put((Name)mapper.apply(type.getName()), (NodeTypeTemplate)type));
        try (Writer writer = writerOpener.open();
             CompactNodeTypeDefWriter cndWriter = new CompactNodeTypeDefWriter(writer, session, true);){
            for (NodeTypeDefinition def : writableTypes.values()) {
                cndWriter.write(def);
            }
        }
    }

    public static Map<Name, NodeTypeDefinition> retrieveNodeTypes(@NotNull Session session, @NotNull Collection<Name> desiredTypeNames) throws RepositoryException {
        return CndExporter.retrieveNodeTypes(session, desiredTypeNames, null);
    }

    public static Map<Name, NodeTypeDefinition> retrieveNodeTypes(@NotNull Session session, @NotNull Collection<Name> desiredTypeNames, @Nullable BiPredicate<NamePathResolver, NodeType> nodeTypeSelector) throws RepositoryException {
        DefaultNamePathResolver resolver = new DefaultNamePathResolver(session);
        LinkedHashMap<Name, NodeType> allTypes = new LinkedHashMap<Name, NodeType>();
        LinkedHashSet<Name> exportableTypeNames = new LinkedHashSet<Name>(desiredTypeNames);
        BiPredicate<NamePathResolver, NodeType> _selector = nodeTypeSelector != null ? nodeTypeSelector : (res, type) -> false;
        NodeTypeIterator iter = session.getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (iter.hasNext()) {
            NodeType type2 = iter.nextNodeType();
            Name name = resolver.getQName(type2.getName());
            allTypes.put(name, type2);
            if (!_selector.test((NamePathResolver)resolver, type2)) continue;
            exportableTypeNames.add(name);
        }
        LinkedHashMap<Name, NodeTypeDefinition> exportedTypes = new LinkedHashMap<Name, NodeTypeDefinition>();
        List typesToAdd = exportableTypeNames.stream().map(arg_0 -> CndExporter.lambda$retrieveNodeTypes$7(allTypes, (NamePathResolver)resolver, arg_0)).collect(Collectors.toList());
        CndExporter.combineCauseMessages(typesToAdd.stream(), NoSuchNodeTypeException.class, NoSuchNodeTypeException.class);
        typesToAdd.stream().flatMap(Result::stream).forEachOrdered(arg_0 -> CndExporter.lambda$retrieveNodeTypes$8((NamePathResolver)resolver, exportedTypes, arg_0));
        return exportedTypes;
    }

    static <T, E extends Throwable> void combineCauseMessages(@NotNull Stream<Result<T>> results, @NotNull Class<? extends Throwable> causeType, @NotNull Class<E> andThrow) throws E {
        String combined = results.filter(Result::isFailure).map(result -> result.findCause(causeType)).filter(Optional::isPresent).map(Optional::get).map(Throwable::getMessage).collect(Collectors.joining(", "));
        if (!combined.isEmpty()) {
            Throwable rethrow;
            try {
                rethrow = (Throwable)andThrow.getConstructor(String.class).newInstance(combined);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(combined, e);
            }
            throw rethrow;
        }
    }

    static <T> Stream<T> optStream(T element) {
        return Optional.ofNullable(element).map(Stream::of).orElse(Stream.empty());
    }

    static Stream<String> ntDepStream(NodeTypeTemplate ntDef) {
        Stream superTypes = CndExporter.optStream(ntDef.getDeclaredSupertypeNames()).flatMap(Stream::of);
        Stream childTypes = ntDef.getNodeDefinitionTemplates().stream().flatMap(nodeDef -> Stream.concat(CndExporter.optStream(nodeDef.getDefaultPrimaryTypeName()), CndExporter.optStream(nodeDef.getRequiredPrimaryTypeNames()).flatMap(Stream::of)));
        return Stream.concat(superTypes, childTypes);
    }

    static void addType(@NotNull NamePathResolver resolver, @NotNull Map<Name, NodeTypeDefinition> typeSet, @NotNull NodeType def) {
        Name name = (Name)Fun.uncheck1(arg_0 -> ((NamePathResolver)resolver).getQName(arg_0)).apply(def.getName());
        if (typeSet.containsKey(name)) {
            return;
        }
        Consumer<NodeType> accum = nt -> CndExporter.addType(resolver, typeSet, nt);
        CndExporter.optStream(def.getDeclaredSupertypes()).flatMap(Stream::of).forEachOrdered(accum);
        typeSet.put(name, (NodeTypeDefinition)def);
        CndExporter.optStream(def.getDeclaredChildNodeDefinitions()).flatMap(Stream::of).flatMap(childDef -> Stream.concat(CndExporter.optStream(childDef.getDefaultPrimaryType()), CndExporter.optStream(childDef.getRequiredPrimaryTypes()).flatMap(Stream::of))).forEachOrdered(accum);
    }

    private static /* synthetic */ void lambda$retrieveNodeTypes$8(NamePathResolver resolver, Map exportedTypes, NodeType def) {
        CndExporter.addType(resolver, exportedTypes, def);
    }

    private static /* synthetic */ Result lambda$retrieveNodeTypes$7(Map allTypes, NamePathResolver resolver, Name qName) {
        if (allTypes.containsKey(qName)) {
            return Result.success(allTypes.get(qName));
        }
        return ((Result)Fun.result1(arg_0 -> ((NamePathResolver)resolver).getJCRName(arg_0)).apply(qName)).flatMap(jcrName -> Result.failure((Exception)new NoSuchNodeTypeException("Failed to find nodetype with name: " + jcrName)));
    }

    @FunctionalInterface
    public static interface WriterOpener {
        @NotNull
        public Writer open() throws IOException;
    }

    public static final class Builder {
        private List<Rule> scopeExportNames;
        private List<Rule> scopeReplaceNames;
        private boolean includeBuiltins;

        public Builder withScopeExportNames(List<Rule> scopeExportNames) {
            this.scopeExportNames = scopeExportNames;
            return this;
        }

        public Builder withScopeReplaceNames(List<Rule> scopeReplaceNames) {
            this.scopeReplaceNames = scopeReplaceNames;
            return this;
        }

        public Builder withIncludeBuiltins(boolean includeBuiltins) {
            this.includeBuiltins = includeBuiltins;
            return this;
        }

        public CndExporter build() {
            return new CndExporter(this.scopeExportNames, this.scopeReplaceNames, this.includeBuiltins);
        }
    }
}

