/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.jcr.NamespaceException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.Result;
import net.adamcin.oakpal.core.JsonCnd;
import net.adamcin.oakpal.webster.QName;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;
import org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.jackrabbit.vault.util.RejectingEntityDefaultHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class FileVaultNameFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileVaultNameFinder.class);
    private final Set<QName> references = new LinkedHashSet<QName>();
    private final Set<QName> definitions = new LinkedHashSet<QName>();

    public FileVaultNameFinder() {
        this.loadBuiltins();
    }

    void loadBuiltins() {
        JsonCnd.BUILTIN_PRIVILEGES.stream().map(Fun.result1(jcrName -> QName.parseQName(JsonCnd.BUILTIN_MAPPINGS, QName.Type.PRIVILEGE, jcrName))).flatMap(Result::stream).forEachOrdered(this::addDefinition);
        JsonCnd.BUILTIN_NODETYPES.stream().map(Fun.result1(jcrName -> QName.parseQName(JsonCnd.BUILTIN_MAPPINGS, QName.Type.NODETYPE, jcrName))).flatMap(Result::stream).forEachOrdered(this::addDefinition);
    }

    void addReference(QName qName) {
        LOGGER.trace("[QName#addReference] qName={}", (Object)qName);
        this.references.add(qName);
    }

    void addDefinition(QName qName) {
        LOGGER.trace("[QName#addDefinition] qName={}", (Object)qName);
        this.definitions.add(qName);
    }

    void collectPrivilegeDefinition(@NotNull NamespaceMapping mapping, @NotNull PrivilegeDefinition def) {
        Function adapterFn = Fun.result1(name -> QName.adaptName(mapping, QName.Type.PRIVILEGE, name));
        ((Result)adapterFn.apply(def.getName())).forEach(this::addDefinition);
        Name defName = def.getName();
        this.addDefinition(QName.adaptName(mapping, QName.Type.PRIVILEGE, defName));
        def.getDeclaredAggregateNames().stream().map(adapterFn).flatMap(Result::stream).forEachOrdered(this::addReference);
    }

    void collectNodeTypeNames(NamespaceMapping mapping, QNodeTypeDefinition def) {
        Function<Name, QName> typeNameTransform = name -> QName.adaptName(mapping, QName.Type.NODETYPE, def.getName());
        ((Function<QName, Optional>)Optional::ofNullable).compose(name -> QName.adaptName(mapping, QName.Type.NODETYPE, def.getName())).apply(def.getName()).ifPresent(this::addDefinition);
        def.getDependencies().stream().map(typeNameTransform).filter(Objects::nonNull).forEachOrdered(this::addReference);
    }

    public Set<QName> search(Archive archive) throws Exception {
        archive.open(false);
        PrivilegeDefinitions defs = archive.getMetaInf().getPrivileges();
        if (defs != null && !defs.getDefinitions().isEmpty()) {
            NamespaceMapping mapping = defs.getNamespaceMapping();
            defs.getDefinitions().forEach(def -> this.collectPrivilegeDefinition(mapping, (PrivilegeDefinition)def));
        }
        Collection nodeTypeSets = archive.getMetaInf().getNodeTypes();
        for (NodeTypeSet nodeTypeSet : nodeTypeSets) {
            NamespaceMapping names = nodeTypeSet.getNamespaceMapping();
            nodeTypeSet.getNodeTypes().values().forEach(def -> this.collectNodeTypeNames(names, (QNodeTypeDefinition)def));
        }
        Archive.Entry rootEntry = archive.getJcrRoot();
        if (rootEntry != null) {
            this.search(archive, rootEntry);
        }
        LinkedHashSet<QName> subtracted = new LinkedHashSet<QName>();
        this.references.stream().filter(((Predicate<QName>)this.definitions::contains).negate()).forEachOrdered(subtracted::add);
        return subtracted;
    }

    void search(Archive archive, Archive.Entry entry) throws IOException {
        if (entry.isDirectory()) {
            for (Archive.Entry child : entry.getChildren()) {
                this.search(archive, child);
            }
        } else {
            String fileName = entry.getName();
            String repoName = PlatformNameFormat.getRepositoryName((String)fileName);
            String ext = "";
            int idx = repoName.lastIndexOf(46);
            if (idx > 0) {
                ext = repoName.substring(idx);
            }
            if (".xml".equals(ext)) {
                Optional.ofNullable(archive.getInputSource(entry)).ifPresent(Fun.uncheckVoid1(this::handleDocView));
            } else if (".cnd".equals(ext)) {
                Optional.ofNullable(archive.getInputSource(entry)).ifPresent(Fun.uncheckVoid1(is -> {
                    try (InputStream input = is.getByteStream();
                         InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                        CNDReader cndReader = ServiceProviderFactory.getProvider().getCNDReader();
                        cndReader.read((Reader)reader, is.getSystemId(), null);
                        NamespaceMapping names = cndReader.getNamespaceMapping();
                        cndReader.getNodeTypes().values().forEach(def -> this.collectNodeTypeNames(names, (QNodeTypeDefinition)def));
                    }
                }));
            }
        }
    }

    void handleDocView(@NotNull VaultInputSource source) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        SAXParser parser = factory.newSAXParser();
        Handler handler = new Handler();
        parser.parse((InputSource)source, (DefaultHandler)((Object)handler));
    }

    final class Handler
    extends RejectingEntityDefaultHandler
    implements NamespaceResolver {
        boolean expectStartElement = false;
        boolean expectEndPrefixMapping = false;
        NamespaceMapping mapping = new NamespaceMapping();
        NsStack mappingStack = new NsStack(this.mapping, null);
        final NamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)this);
        Boolean isDocView = null;

        Handler() {
        }

        public void startPrefixMapping(@NotNull String prefix, @NotNull String uri) throws SAXException {
            if (!this.expectStartElement) {
                this.mapping = new NamespaceMapping((NamespaceResolver)this.mapping);
                this.mappingStack = new NsStack(this.mapping, this.mappingStack);
                this.expectStartElement = true;
                this.expectEndPrefixMapping = true;
            }
            this.setMapping(prefix, uri);
        }

        public void endPrefixMapping(@NotNull String prefix) throws SAXException {
            if (this.expectEndPrefixMapping) {
                if (this.mappingStack.next == null) {
                    throw new IllegalStateException("namespace mapping stack is out of sync");
                }
                this.mappingStack = this.mappingStack.next;
                this.mapping = this.mappingStack.mapping;
                this.expectEndPrefixMapping = false;
            }
        }

        final void setMapping(String prefix, String uri) throws SAXException {
            try {
                this.mapping.setMapping(prefix, uri);
            }
            catch (NamespaceException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.expectStartElement = false;
            LOGGER.trace("[Handler#startElement] uri={} localName={} qName={} attributes={}", new Object[]{uri, localName, qName, attributes});
            if (this.isDocView == null) {
                this.isDocView = "jcr:root".equals(qName);
            }
            if (!this.isDocView.booleanValue()) {
                return;
            }
            String label = ISO9075.decode((String)qName);
            String name = this.nameFromLabel(label);
            if (attributes.getLength() > 0) {
                DocViewNode ni = this.createNode(name, label, attributes);
                if (ni.primary != null) {
                    ((Result)Fun.result0(() -> QName.parseQName(this.mapping, QName.Type.NODETYPE, ni.primary)).get()).forEach(FileVaultNameFinder.this::addReference);
                }
                if (ni.mixins != null) {
                    Stream.of(ni.mixins).map(Fun.result1(type -> QName.parseQName(this.mapping, QName.Type.NODETYPE, type))).flatMap(Result::stream).forEachOrdered(FileVaultNameFinder.this::addReference);
                }
                if (ni.props.containsKey("rep:privileges")) {
                    DocViewProperty prop = (DocViewProperty)ni.props.get("rep:privileges");
                    if (prop.values != null && (prop.type == 0 || prop.type == 1 || prop.type == 7)) {
                        Stream.of(prop.values).map(Fun.result1(type -> QName.parseQName(this.mapping, QName.Type.PRIVILEGE, type))).flatMap(Result::stream).forEachOrdered(FileVaultNameFinder.this::addReference);
                    }
                }
            }
        }

        String nameFromLabel(@NotNull String label) {
            int idx = label.lastIndexOf(91);
            if (idx > 0) {
                return label.substring(0, idx);
            }
            return label;
        }

        DocViewNode createNode(String name, String label, Attributes attributes) throws SAXException {
            try {
                return new DocViewNode(name, label, attributes, this.npResolver);
            }
            catch (NamespaceException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }

        public String getURI(String prefix) throws NamespaceException {
            return this.mapping.getURI(prefix);
        }

        public String getPrefix(String uri) throws NamespaceException {
            return this.mapping.getPrefix(uri);
        }
    }

    static final class NsStack {
        final NsStack next;
        final NamespaceMapping mapping;

        NsStack(@NotNull NamespaceMapping mapping, @Nullable NsStack next) {
            this.mapping = mapping;
            this.next = next;
        }
    }
}

