/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.security.Privilege;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.core.JsonCnd;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionWriter;
import org.jetbrains.annotations.NotNull;

public final class PrivilegeXmlExporter {
    private PrivilegeXmlExporter() {
    }

    public static void writePrivileges(WriterOpener writerOpener, Session session, List<String> onlyNames, boolean includeBuiltins) throws RepositoryException, IOException {
        Set explicitNames;
        Workspace workspace = session.getWorkspace();
        if (!(workspace instanceof JackrabbitWorkspace)) {
            throw new RepositoryException("Workspace must be instance of JackrabbitWorkspace, but isn't. type: " + workspace.getClass().getName());
        }
        DefaultNamePathResolver resolver = new DefaultNamePathResolver(session);
        Function mapper = Fun.tryOrDefault1(arg_0 -> ((NamePathResolver)resolver).getQName(arg_0), null);
        Set builtinPrivileges = JsonCnd.BUILTIN_PRIVILEGES.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toSet());
        Predicate<Name> builtinFilter = includeBuiltins ? name -> true : ((Predicate<Name>)builtinPrivileges::contains).negate();
        Set set = explicitNames = onlyNames != null ? onlyNames.stream().map(mapper).filter(Objects::nonNull).filter(builtinFilter).collect(Collectors.toSet()) : Collections.emptySet();
        Predicate<Name> shouldInclude = !explicitNames.isEmpty() ? explicitNames::contains : builtinFilter;
        PrivilegeManager privilegeManager = ((JackrabbitWorkspace)workspace).getPrivilegeManager();
        ArrayList<PrivilegeDefinitionImpl> privilegeDefinitions = new ArrayList<PrivilegeDefinitionImpl>();
        for (Privilege privilege : privilegeManager.getRegisteredPrivileges()) {
            if (!shouldInclude.test((Name)mapper.apply(privilege.getName()))) continue;
            PrivilegeDefinitionImpl privilegeDefinition = new PrivilegeDefinitionImpl((Name)mapper.apply(privilege.getName()), privilege.isAbstract(), Stream.of(privilege.getDeclaredAggregatePrivileges()).map(Privilege::getName).map(mapper).filter(Objects::nonNull).collect(Collectors.toSet()));
            privilegeDefinitions.add(privilegeDefinition);
        }
        Set uris = privilegeDefinitions.stream().flatMap(def -> Stream.concat(Stream.of(def.getName()), def.getDeclaredAggregateNames().stream())).map(Name::getNamespaceURI).collect(Collectors.toSet());
        Map namespaces = uris.stream().collect(Collectors.toMap(Fun.tryOrDefault1(arg_0 -> ((Session)session).getNamespacePrefix(arg_0), null), Function.identity()));
        PrivilegeDefinitionWriter pdWriter = new PrivilegeDefinitionWriter("text/xml");
        try (Writer writer = writerOpener.open();){
            pdWriter.writeDefinitions(writer, privilegeDefinitions.toArray(new PrivilegeDefinition[0]), namespaces);
        }
    }

    @FunctionalInterface
    public static interface WriterOpener {
        @NotNull
        public Writer open() throws IOException;
    }
}

