/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.util.Objects;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.Result;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QName {
    private final Type type;
    private final String prefix;
    private final String localName;
    private final String uri;

    public QName(@NotNull Type type, @Nullable String prefix, @NotNull String localName, @Nullable String uri) {
        this.type = type;
        this.prefix = prefix;
        this.localName = localName;
        this.uri = uri;
    }

    public static QName parseQName(@NotNull NamespaceMapping mapping, @NotNull Type type, @NotNull String qName) {
        if (qName.startsWith("{") && qName.contains("}")) {
            int lastBrace = qName.indexOf("}");
            String uri = qName.substring(1, lastBrace);
            String localName = qName.substring(lastBrace + 1);
            return new QName(type, ((Result)Fun.result1(arg_0 -> ((NamespaceMapping)mapping).getPrefix(arg_0)).apply(uri)).toOptional().orElse(null), localName, uri);
        }
        if (qName.contains(":")) {
            String[] parts = qName.split(":", 2);
            String prefix = parts[0];
            String localName = parts[1];
            return new QName(type, prefix, localName, ((Result)Fun.result1(arg_0 -> ((NamespaceMapping)mapping).getURI(arg_0)).apply(prefix)).toOptional().orElse(null));
        }
        throw new UnqualifiedNameException(qName);
    }

    public static QName adaptName(@NotNull NamespaceMapping mapping, @NotNull Type type, @NotNull Name name) {
        return new QName(type, ((Result)Fun.result1(arg_0 -> ((NamespaceMapping)mapping).getPrefix(arg_0)).apply(name.getNamespaceURI())).toOptional().orElse(null), name.getLocalName(), name.getNamespaceURI());
    }

    public Type getType() {
        return this.type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        if (this.prefix != null) {
            return this.getPrefix() + ":" + this.getLocalName();
        }
        return this.toExpandedForm();
    }

    public String toExpandedForm() {
        return "{" + this.getUri() + "}" + this.getLocalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QName qName = (QName)o;
        return this.type == qName.type && this.localName.equals(qName.localName) && this.uri.equals(qName.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.localName, this.uri});
    }

    public static enum Type {
        PRIVILEGE,
        NODETYPE;

    }

    public static final class UnqualifiedNameException
    extends RuntimeException {
        UnqualifiedNameException(@NotNull String jcrName) {
            super(jcrName + " is not a qualified name (expected prefix:localName or {uri}localName format)");
        }
    }
}

