/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import net.adamcin.oakpal.webster.ArchiveAware;
import net.adamcin.oakpal.webster.JcrFactory;
import net.adamcin.oakpal.webster.WebsterTarget;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.run.cli.NodeStoreFixture;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.FileArchive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebsterPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsterPlan.class);
    private static final FixtureProvider DEFAULT_FIXTURE_PROVIDER = new FixtureProvider(){

        @Override
        public NodeStoreFixture openFixture() throws Exception {
            throw new IllegalStateException("A fixture provider must be supplied to the builder.");
        }
    };
    private final FixtureProvider fixtureProvider;
    private final File globalSegmentStore;
    private final List<WebsterTarget> targets;
    private final File archiveRoot;

    WebsterPlan(@NotNull FixtureProvider fixtureProvider, @NotNull List<WebsterTarget> targets, @Nullable File globalSegmentStore, @Nullable File archiveRoot) {
        this.fixtureProvider = fixtureProvider;
        this.targets = new ArrayList<WebsterTarget>(targets);
        this.globalSegmentStore = globalSegmentStore;
        this.archiveRoot = archiveRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performWithGlobalSegment() throws Exception {
        LOGGER.info("Webster Plan: Performing plan with SegmentTar global nodestore...");
        try (NodeStoreFixture fixture = this.fixtureProvider.openFixture();
             NodeStoreFixture globalFixture = JcrFactory.getReadWriteFixture(this.globalSegmentStore, new String[0]);){
            Repository repo = null;
            Session session = null;
            try {
                repo = JcrFactory.getJcr(fixture, globalFixture.getStore());
                session = repo.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
                this.internalPerform(session);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
                if (repo instanceof JackrabbitRepository) {
                    ((JackrabbitRepository)repo).shutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performWithGlobalMemory() throws Exception {
        LOGGER.info("Webster Plan: Performing plan with in-memory global nodestore...");
        try (NodeStoreFixture fixture = this.fixtureProvider.openFixture();){
            Repository repo = null;
            Session session = null;
            try {
                repo = JcrFactory.getJcr(fixture);
                session = repo.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
                this.internalPerform(session);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
                if (repo instanceof JackrabbitRepository) {
                    ((JackrabbitRepository)repo).shutdown();
                }
            }
        }
    }

    void internalPerform(Session session) throws Exception {
        for (WebsterTarget target : this.targets) {
            if (target instanceof ArchiveAware) {
                ((ArchiveAware)((Object)target)).setArchive(this.createArchive(), this.archiveRoot);
            }
            target.perform(session);
        }
    }

    Archive createArchive() throws IOException {
        if (this.archiveRoot == null || !this.archiveRoot.isDirectory()) {
            throw new IllegalArgumentException("archiveRoot must be an existing directory");
        }
        FileArchive archive = new FileArchive(this.archiveRoot);
        if (!new File(this.archiveRoot, "jcr_root").exists()) {
            throw new IllegalArgumentException("archiveRoot must have a child jcr_root directory");
        }
        File archiveMetaInfVault = new File(this.archiveRoot, "META-INF/vault");
        if (!archiveMetaInfVault.isDirectory()) {
            archiveMetaInfVault.mkdirs();
        }
        archive.open(false);
        return archive;
    }

    public void perform() throws Exception {
        if (this.globalSegmentStore == null) {
            this.performWithGlobalMemory();
        } else {
            this.performWithGlobalSegment();
        }
    }

    static /* synthetic */ FixtureProvider access$000() {
        return DEFAULT_FIXTURE_PROVIDER;
    }

    public static final class Builder {
        private FixtureProvider fixtureProvider = WebsterPlan.access$000();
        private File globalSegmentStore;
        private File archiveRoot;
        private final List<WebsterTarget> targets = new ArrayList<WebsterTarget>();

        public Builder withFixtureProvider(@NotNull FixtureProvider fixtureProvider) {
            this.fixtureProvider = fixtureProvider;
            return this;
        }

        public Builder withGlobalSegmentStore(@NotNull File globalSegmentStore) {
            this.globalSegmentStore = globalSegmentStore;
            return this;
        }

        public Builder withGlobalMemoryStore() {
            this.globalSegmentStore = null;
            return this;
        }

        public Builder withArchiveRoot(@NotNull File archiveRoot) {
            this.archiveRoot = archiveRoot;
            return this;
        }

        public Builder withTarget(WebsterTarget ... target) {
            return this.withTargets(Arrays.asList(target));
        }

        public Builder withTargets(@NotNull List<WebsterTarget> targets) {
            this.targets.addAll(targets);
            return this;
        }

        public WebsterPlan build() {
            return new WebsterPlan(this.fixtureProvider, this.targets, this.globalSegmentStore, this.archiveRoot);
        }
    }

    @FunctionalInterface
    public static interface FixtureProvider {
        public NodeStoreFixture openFixture() throws Exception;
    }
}

