/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster.targets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.JavaxJson;
import net.adamcin.oakpal.webster.WebsterTarget;
import net.adamcin.oakpal.webster.WebsterTargetFactory;
import net.adamcin.oakpal.webster.targets.WebsterChecklistTarget;
import net.adamcin.oakpal.webster.targets.WebsterNodetypesTarget;
import net.adamcin.oakpal.webster.targets.WebsterPrivilegesTarget;
import org.jetbrains.annotations.NotNull;

public enum JsonTargetFactory implements WebsterTargetFactory
{
    NODETYPES(WebsterNodetypesTarget::fromJson),
    PRIVILEGES((target, config) -> new WebsterPrivilegesTarget(target)),
    CHECKLIST(WebsterChecklistTarget::fromJson);

    private WebsterTargetFactory actionFactory;
    public static final String KEY_TYPE = "type";
    public static final String KEY_FILE = "file";
    public static final String KEY_CONFIG = "config";
    public static final String HINT_KEY_MORE_TARGETS = "moreTargets";

    private JsonTargetFactory(WebsterTargetFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public static JsonTargetFactory byType(String type) {
        for (JsonTargetFactory value : JsonTargetFactory.values()) {
            if (!value.name().equalsIgnoreCase(type)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown JsonActionFactory type: " + type);
    }

    public static boolean isTargetType(String type) {
        for (JsonTargetFactory value : JsonTargetFactory.values()) {
            if (!value.name().equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public static WebsterTarget fromJson(File baseDir, JsonObject json, String hint) throws Exception {
        String action = json.getString(KEY_TYPE, hint);
        File target = json.containsKey((Object)KEY_FILE) ? new File(baseDir, json.getString(KEY_FILE)) : null;
        JsonObject config = json.containsKey((Object)KEY_CONFIG) ? json.getJsonObject(KEY_CONFIG) : JavaxJson.obj((JavaxJson.Key[])new JavaxJson.Key[0]).get();
        return JsonTargetFactory.byType(action).createTarget(target, config);
    }

    public static List<WebsterTarget> fromJsonHintMap(@NotNull File baseDir, @NotNull JsonObject jsonHintMap) throws Exception {
        ArrayList<WebsterTarget> targets = new ArrayList<WebsterTarget>();
        for (Map.Entry entry : jsonHintMap.entrySet()) {
            if (JsonTargetFactory.isTargetType((String)entry.getKey())) {
                if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.OBJECT) {
                    targets.add(JsonTargetFactory.fromJson(baseDir, ((JsonValue)entry.getValue()).asJsonObject(), (String)entry.getKey()));
                    continue;
                }
                targets.add(JsonTargetFactory.fromJson(baseDir, JavaxJson.obj((JavaxJson.Key[])new JavaxJson.Key[0]).get(), (String)entry.getKey()));
                continue;
            }
            if (!HINT_KEY_MORE_TARGETS.equals(entry.getKey())) continue;
            if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.ARRAY) {
                targets.addAll(JavaxJson.mapArrayOfObjects((JsonArray)((JsonValue)entry.getValue()).asJsonArray(), (Function)Fun.uncheck1(json -> JsonTargetFactory.fromJson(baseDir, json, null))));
                continue;
            }
            if (((JsonValue)entry.getValue()).getValueType() != JsonValue.ValueType.OBJECT) continue;
            targets.addAll(JavaxJson.mapObjectValues((JsonObject)((JsonValue)entry.getValue()).asJsonObject(), (BiFunction)Fun.uncheck2((label, json) -> JsonTargetFactory.fromJson(baseDir, json, label)), (boolean)true));
        }
        return targets;
    }

    @Override
    public WebsterTarget createTarget(File targetFile, JsonObject config) throws Exception {
        return this.actionFactory.createTarget(targetFile, config);
    }
}

