/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster.targets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Session;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import net.adamcin.oakpal.api.JavaxJson;
import net.adamcin.oakpal.api.Rules;
import net.adamcin.oakpal.core.Checklist;
import net.adamcin.oakpal.core.JcrNs;
import net.adamcin.oakpal.webster.ChecklistExporter;
import net.adamcin.oakpal.webster.WebsterTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebsterChecklistTarget
implements WebsterTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsterChecklistTarget.class);
    static final String KEY_TYPE = "type";
    static final String KEY_ARGS = "args";
    static final String COMPACT_KEY_BY_NODETYPES = "selectNodeTypes";
    static final String COMPACT_KEY_BY_PATHS = "selectPaths";
    static final String COMPACT_KEY_BY_QUERY = "selectQuery";
    static final String KEY_SELECTORS = "selectors";
    static final String KEY_SCOPE_PATHS = "scopePaths";
    static final String KEY_NODE_TYPE_FILTERS = "nodeTypeFilters";
    static final String KEY_JCR_NAMESPACES = "jcrNamespaces";
    static final String KEY_UPDATE_POLICY = "updatePolicy";
    static final String KEY_EXPORT_NODETYPES = "exportNodeTypes";
    private final File checklist;
    private final ChecklistExporter exporter;
    private final ChecklistExporter.ForcedRootUpdatePolicy updatePolicy;

    static Selector selectorFromJson(JsonObject json) {
        ChecklistExporter.SelectorType type = ChecklistExporter.SelectorType.byName(json.getString(KEY_TYPE));
        String[] args = JavaxJson.mapArrayOfStrings((JsonArray)json.getJsonArray(KEY_ARGS)).toArray(new String[0]);
        return new Selector(type, args);
    }

    static List<Selector> selectorsFromConfigCompactForm(JsonObject json) {
        List args;
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        if (json.containsKey((Object)COMPACT_KEY_BY_NODETYPES)) {
            args = JavaxJson.mapArrayOfStrings((JsonArray)json.getJsonArray(COMPACT_KEY_BY_NODETYPES));
            selectors.add(new Selector(ChecklistExporter.SelectorType.NODETYPE, args.toArray(new String[0])));
        }
        if (json.containsKey((Object)COMPACT_KEY_BY_PATHS)) {
            args = JavaxJson.mapArrayOfStrings((JsonArray)json.getJsonArray(COMPACT_KEY_BY_PATHS));
            selectors.add(new Selector(ChecklistExporter.SelectorType.PATH, args.toArray(new String[0])));
        }
        if (json.containsKey((Object)COMPACT_KEY_BY_QUERY)) {
            selectors.add(new Selector(ChecklistExporter.SelectorType.QUERY, new String[]{json.getString(COMPACT_KEY_BY_QUERY)}));
        }
        return selectors;
    }

    private WebsterChecklistTarget(File checklist, ChecklistExporter exporter, ChecklistExporter.ForcedRootUpdatePolicy updatePolicy) {
        this.checklist = checklist;
        this.exporter = exporter;
        this.updatePolicy = updatePolicy;
    }

    @Override
    public void perform(Session session) throws Exception {
        JsonObject json;
        if (!this.checklist.exists()) {
            this.checklist.getParentFile().mkdirs();
            json = JavaxJson.obj((JavaxJson.Key[])new JavaxJson.Key[0]).get();
        } else {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.checklist), StandardCharsets.UTF_8);
                 JsonReader jsonReader = Json.createReader((Reader)reader);){
                json = jsonReader.readObject();
            }
        }
        this.exporter.updateChecklist(() -> new OutputStreamWriter((OutputStream)new FileOutputStream(this.checklist), StandardCharsets.UTF_8), session, Checklist.fromJson((String)"webster-temp", null, (JsonObject)json), this.updatePolicy);
        LOGGER.info("Checklist JSON written to {}", (Object)this.checklist.getAbsolutePath());
    }

    static WebsterChecklistTarget fromJson(File target, JsonObject config) {
        LOGGER.debug("[fromJson] fromJson: {}", (Object)config.toString());
        ChecklistExporter.Builder exporter = new ChecklistExporter.Builder();
        WebsterChecklistTarget.selectorsFromConfigCompactForm(config).forEach(selector -> selector.selectOnExporter(exporter));
        if (config.containsKey((Object)KEY_SELECTORS)) {
            JsonArray ops = config.getJsonArray(KEY_SELECTORS);
            List selectors = JavaxJson.mapArrayOfObjects((JsonArray)ops, WebsterChecklistTarget::selectorFromJson);
            selectors.forEach(selector -> selector.selectOnExporter(exporter));
        }
        if (config.containsKey((Object)KEY_SCOPE_PATHS)) {
            List scopePaths = Rules.fromJsonArray((JsonArray)config.getJsonArray(KEY_SCOPE_PATHS));
            exporter.withScopePaths(scopePaths);
        }
        if (config.containsKey((Object)KEY_NODE_TYPE_FILTERS)) {
            List nodeTypeFilters = Rules.fromJsonArray((JsonArray)config.getJsonArray(KEY_NODE_TYPE_FILTERS));
            exporter.withNodeTypeFilters(nodeTypeFilters);
        }
        if (config.containsKey((Object)KEY_JCR_NAMESPACES)) {
            List jcrNsList = JavaxJson.mapArrayOfObjects((JsonArray)config.getJsonArray(KEY_JCR_NAMESPACES), JcrNs::fromJson);
            exporter.withJcrNamespaces(jcrNsList);
        }
        if (config.containsKey((Object)KEY_EXPORT_NODETYPES)) {
            List ntList = JavaxJson.mapArrayOfStrings((JsonArray)config.getJsonArray(KEY_EXPORT_NODETYPES));
            exporter.withExportNodeTypes(ntList);
        }
        ChecklistExporter.ForcedRootUpdatePolicy updatePolicy = null;
        if (config.containsKey((Object)KEY_UPDATE_POLICY)) {
            updatePolicy = ChecklistExporter.ForcedRootUpdatePolicy.byName(config.getString(KEY_UPDATE_POLICY));
        }
        return new WebsterChecklistTarget(target, exporter.build(), updatePolicy);
    }

    static final class Selector {
        private final ChecklistExporter.SelectorType type;
        private final String[] args;

        Selector(ChecklistExporter.SelectorType type, String[] args) {
            LOGGER.debug("[Selector] type={}, args={}", (Object)type, (Object)Arrays.toString(args));
            this.type = type;
            this.args = args;
        }

        ChecklistExporter.SelectorType getType() {
            return this.type;
        }

        List<String> getArgs() {
            return Arrays.asList(this.args);
        }

        void selectOnExporter(ChecklistExporter.Builder exporter) {
            switch (this.type) {
                case PATH: {
                    exporter.byPath(this.args);
                    break;
                }
                case NODETYPE: {
                    exporter.byNodeType(this.args);
                    break;
                }
                default: {
                    exporter.byQuery(this.args[0]);
                }
            }
        }
    }
}

