/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CliArgParser {
    private CliArgParser() {
    }

    static List<Token> lex(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Matcher matcher = TokenType.tokenPattern().matcher(input);
        block0: while (matcher.find()) {
            for (TokenType tokenType : TokenType.values()) {
                Token token = tokenType.nextFromMatcher(matcher);
                if (token == null) continue;
                tokens.add(token);
                continue block0;
            }
        }
        return tokens;
    }

    public static String[] parse(String input) {
        List<Token> tokens = CliArgParser.lex(input);
        Parser parser = new Parser();
        for (Token token : tokens) {
            parser.parseNext(token);
        }
        return parser.getArgs().toArray(new String[0]);
    }

    static final class Parser {
        final List<String> args = new ArrayList<String>();
        StringBuilder arg = new StringBuilder();
        boolean escaped;
        boolean quoted;

        Parser() {
        }

        void parseNext(Token token) {
            switch (token.type) {
                case WHITESPACE: {
                    this.onWhitespace(token);
                    break;
                }
                case ESCAPE: {
                    this.onEscape(token);
                    break;
                }
                case QUOTE: {
                    this.onQuote(token);
                    break;
                }
                default: {
                    this.onArg(token);
                }
            }
        }

        private void onWhitespace(Token token) {
            if (this.escaped) {
                this.arg.append(token.data);
                this.escaped = false;
            } else if (this.quoted) {
                this.arg.append(token.data);
            } else if (this.arg.length() > 0) {
                this.args.add(this.arg.toString());
                this.arg = new StringBuilder();
            }
        }

        private void onEscape(Token token) {
            if (this.escaped) {
                this.arg.append(token.data);
                this.escaped = false;
            } else {
                this.escaped = true;
            }
        }

        private void onArg(Token token) {
            this.arg.append(token.data);
            this.escaped = false;
        }

        private void onQuote(Token token) {
            if (this.escaped) {
                this.arg.append(token.data);
                this.escaped = false;
            } else {
                this.quoted = !this.quoted;
            }
        }

        List<String> getArgs() {
            if (this.escaped) {
                throw new IllegalStateException("Unterminated escape sequence.");
            }
            if (this.quoted) {
                throw new IllegalStateException("Unterminated quote (\") sequence.");
            }
            if (this.arg.length() > 0) {
                this.args.add(this.arg.toString());
                this.arg = new StringBuilder();
            }
            return this.args;
        }
    }

    static final class Token {
        final TokenType type;
        final String data;

        Token(TokenType type, String data) {
            this.type = type;
            this.data = data;
        }

        public String toString() {
            return String.format("(%s %s)", this.type.name(), this.data);
        }
    }

    static enum TokenType {
        WHITESPACE("\\s"),
        ESCAPE("\\\\"),
        QUOTE("\""),
        ARG("[^\"\\s\\\\]+");

        final String pattern;

        private TokenType(String pattern) {
            this.pattern = pattern;
        }

        Token nextFromMatcher(Matcher matcher) {
            if (matcher.group(this.name()) != null) {
                return new Token(this, matcher.group(this.name()));
            }
            return null;
        }

        static Pattern tokenPattern() {
            StringBuilder sb = new StringBuilder();
            for (TokenType tokenType : TokenType.values()) {
                sb.append(String.format("|(?<%s>%s)", tokenType.name(), tokenType.pattern));
            }
            return Pattern.compile(sb.substring(1));
        }
    }
}

