/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import net.adamcin.oakpal.api.Fun;
import net.adamcin.oakpal.api.Result;
import net.adamcin.oakpal.core.JsonCnd;
import net.adamcin.oakpal.webster.QName;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;
import org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class FileVaultNameFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileVaultNameFinder.class);
    private final Set<QName> references = new LinkedHashSet<QName>();
    private final Set<QName> definitions = new LinkedHashSet<QName>();

    public FileVaultNameFinder() {
        this.loadBuiltins();
    }

    void loadBuiltins() {
        JsonCnd.BUILTIN_PRIVILEGES.stream().map(Fun.result1(jcrName -> QName.parseQName(JsonCnd.BUILTIN_MAPPINGS, QName.Type.PRIVILEGE, jcrName))).flatMap(Result::stream).forEachOrdered(this::addDefinition);
        JsonCnd.BUILTIN_NODETYPES.stream().map(Fun.result1(jcrName -> QName.parseQName(JsonCnd.BUILTIN_MAPPINGS, QName.Type.NODETYPE, jcrName))).flatMap(Result::stream).forEachOrdered(this::addDefinition);
    }

    void addReference(QName qName) {
        LOGGER.trace("[QName#addReference] qName={}", (Object)qName);
        this.references.add(qName);
    }

    void addDefinition(QName qName) {
        LOGGER.trace("[QName#addDefinition] qName={}", (Object)qName);
        this.definitions.add(qName);
    }

    void collectPrivilegeDefinition(@NotNull NamespaceMapping mapping, @NotNull PrivilegeDefinition def) {
        Function adapterFn = Fun.result1(name -> QName.adaptName(mapping, QName.Type.PRIVILEGE, name));
        ((Result)adapterFn.apply(def.getName())).forEach(this::addDefinition);
        Name defName = def.getName();
        this.addDefinition(QName.adaptName(mapping, QName.Type.PRIVILEGE, defName));
        def.getDeclaredAggregateNames().stream().map(adapterFn).flatMap(Result::stream).forEachOrdered(this::addReference);
    }

    void collectNodeTypeNames(NamespaceMapping mapping, QNodeTypeDefinition def) {
        Function<Name, QName> typeNameTransform = name -> QName.adaptName(mapping, QName.Type.NODETYPE, def.getName());
        ((Function<QName, Optional>)Optional::ofNullable).compose(name -> QName.adaptName(mapping, QName.Type.NODETYPE, def.getName())).apply(def.getName()).ifPresent(this::addDefinition);
        def.getDependencies().stream().map(typeNameTransform).filter(Objects::nonNull).forEachOrdered(this::addReference);
    }

    public Set<QName> search(Archive archive) throws Exception {
        archive.open(false);
        PrivilegeDefinitions defs = archive.getMetaInf().getPrivileges();
        if (defs != null && !defs.getDefinitions().isEmpty()) {
            NamespaceMapping mapping = defs.getNamespaceMapping();
            defs.getDefinitions().forEach(def -> this.collectPrivilegeDefinition(mapping, (PrivilegeDefinition)def));
        }
        Collection nodeTypeSets = archive.getMetaInf().getNodeTypes();
        for (NodeTypeSet nodeTypeSet : nodeTypeSets) {
            NamespaceMapping names = nodeTypeSet.getNamespaceMapping();
            nodeTypeSet.getNodeTypes().values().forEach(def -> this.collectNodeTypeNames(names, (QNodeTypeDefinition)def));
        }
        Archive.Entry rootEntry = archive.getJcrRoot();
        if (rootEntry != null) {
            this.search(archive, rootEntry, null);
        }
        LinkedHashSet<QName> subtracted = new LinkedHashSet<QName>();
        this.references.stream().filter(((Predicate<QName>)this.definitions::contains).negate()).forEachOrdered(subtracted::add);
        return subtracted;
    }

    void search(Archive archive, Archive.Entry entry, Path parentPath) throws IOException {
        Path currentPath;
        Path path = currentPath = parentPath == null ? Path.of(entry.getName(), new String[0]) : parentPath.resolve(entry.getName());
        if (entry.isDirectory()) {
            for (Archive.Entry child : entry.getChildren()) {
                this.search(archive, child, currentPath);
            }
        } else {
            String fileName = entry.getName();
            String repoName = PlatformNameFormat.getRepositoryName((String)fileName);
            String ext = "";
            int idx = repoName.lastIndexOf(46);
            if (idx > 0) {
                ext = repoName.substring(idx);
            }
            if (".xml".equals(ext)) {
                Optional.ofNullable(archive.getInputSource(entry)).map(source -> Fun.toEntry((Object)source, (Object)currentPath)).ifPresent(Fun.onEntry((BiConsumer)Fun.uncheckVoid2(this::handleDocView)));
            } else if (".cnd".equals(ext)) {
                Optional.ofNullable(archive.getInputSource(entry)).ifPresent(Fun.uncheckVoid1(is -> {
                    try (InputStream input = is.getByteStream();
                         InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                        CNDReader cndReader = ServiceProviderFactory.getProvider().getCNDReader();
                        cndReader.read((Reader)reader, is.getSystemId(), null);
                        NamespaceMapping names = cndReader.getNamespaceMapping();
                        cndReader.getNodeTypes().values().forEach(def -> this.collectNodeTypeNames(names, (QNodeTypeDefinition)def));
                    }
                }));
            }
        }
    }

    void handleDocView(@NotNull VaultInputSource source, @NotNull Path filePath) throws DocViewParser.XmlParseException, IOException {
        DocViewParser parser = new DocViewParser((NamespaceResolver)new NamespaceMapping((NamespaceResolver)JsonCnd.BUILTIN_MAPPINGS));
        Handler handler = new Handler();
        Optional rootNodePath = ((Result)Fun.result0(() -> DocViewParser.getDocumentViewXmlRootNodePath((InputStream)source.getByteStream(), (Path)filePath)).get()).toOptional();
        if (rootNodePath.isPresent()) {
            parser.parse((String)rootNodePath.get(), (InputSource)source, (DocViewParserHandler)handler);
        }
    }

    final class Handler
    implements DocViewParserHandler,
    NamespaceResolver {
        boolean expectStartElement = false;
        boolean expectEndPrefixMapping = false;
        NamespaceMapping mapping = new NamespaceMapping((NamespaceResolver)JsonCnd.BUILTIN_MAPPINGS);
        NsStack mappingStack = new NsStack(this.mapping, null);
        final NamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)this);

        Handler() {
        }

        public void startPrefixMapping(@NotNull String prefix, @NotNull String uri) {
            if (!this.expectStartElement) {
                this.mapping = new NamespaceMapping((NamespaceResolver)this.mapping);
                this.mappingStack = new NsStack(this.mapping, this.mappingStack);
                this.expectStartElement = true;
                this.expectEndPrefixMapping = true;
            }
            this.setMapping(prefix, uri);
        }

        public void endPrefixMapping(@NotNull String prefix) {
            if (this.expectEndPrefixMapping) {
                if (this.mappingStack.next == null) {
                    throw new IllegalStateException("namespace mapping stack is out of sync");
                }
                this.mappingStack = this.mappingStack.next;
                this.mapping = this.mappingStack.mapping;
                this.expectEndPrefixMapping = false;
            }
        }

        void setMapping(String prefix, String uri) {
            Fun.uncheckVoid2((arg_0, arg_1) -> ((NamespaceMapping)this.mapping).setMapping(arg_0, arg_1)).accept(prefix, uri);
        }

        public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
            int ptype;
            LOGGER.trace("[Handler#startDocViewNode] nodePath={} docViewNode={} parentDocViewNode={} pos={}:{}", new Object[]{nodePath, docViewNode, parentDocViewNode, line, column});
            if (docViewNode.getPrimaryType().isPresent()) {
                ((Result)Fun.result0(() -> QName.parseQName(this.mapping, QName.Type.NODETYPE, (String)docViewNode.getPrimaryType().get())).get()).forEach(FileVaultNameFinder.this::addReference);
            }
            docViewNode.getMixinTypes().stream().map(Fun.result1(type -> QName.parseQName(this.mapping, QName.Type.NODETYPE, type))).flatMap(Result::stream).forEachOrdered(FileVaultNameFinder.this::addReference);
            Optional privs = docViewNode.getProperty(this.npResolver.getQName("rep:privileges"));
            if (privs.isPresent() && ((ptype = ((DocViewProperty2)privs.get()).getType()) == 0 || ptype == 1 || ptype == 7)) {
                ((DocViewProperty2)privs.get()).getStringValues().stream().map(Fun.result1(type -> QName.parseQName(this.mapping, QName.Type.PRIVILEGE, type))).flatMap(Result::stream).forEachOrdered(FileVaultNameFinder.this::addReference);
            }
        }

        public void endDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) {
        }

        public String getURI(String prefix) throws NamespaceException {
            return this.mapping.getURI(prefix);
        }

        public String getPrefix(String uri) throws NamespaceException {
            return this.mapping.getPrefix(uri);
        }
    }

    static final class NsStack {
        final NsStack next;
        final NamespaceMapping mapping;

        NsStack(@NotNull NamespaceMapping mapping, @Nullable NsStack next) {
            this.mapping = mapping;
            this.next = next;
        }
    }
}

