/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.jcr.Repository;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.adamcin.oakpal.api.Fun;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.composite.CompositeNodeStore;
import org.apache.jackrabbit.oak.composite.InitialContentMigrator;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.run.cli.NodeStoreFixture;
import org.apache.jackrabbit.oak.run.cli.NodeStoreFixtureProvider;
import org.apache.jackrabbit.oak.run.cli.Options;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;

public final class JcrFactory {
    private JcrFactory() {
    }

    public static Repository getJcr(NodeStoreFixture nodeStoreFixture) throws IOException, CommitFailedException {
        return JcrFactory.getJcr(nodeStoreFixture, (NodeStore)new MemoryNodeStore());
    }

    public static Repository getJcr(NodeStoreFixture nodeStoreFixture, NodeStore globalStore) throws IOException, CommitFailedException {
        List<String> globalRoots = Arrays.asList(":async", "jcr:system", "oak:index", "rep:security");
        Predicate ownedRootFilter = Fun.inSet(globalRoots).negate();
        String[] mountPaths = (String[])StreamSupport.stream(nodeStoreFixture.getStore().getRoot().getChildNodeNames().spliterator(), false).filter(ownedRootFilter).map(child -> "/" + child).toArray(String[]::new);
        MountInfoProvider mounts = Mounts.newBuilder().readOnlyMount("source", mountPaths).build();
        new InitialContentMigrator(globalStore, nodeStoreFixture.getStore(), mounts.getMountByName("source")).migrate();
        CompositeNodeStore cns = new CompositeNodeStore.Builder(mounts, globalStore).addMount("source", nodeStoreFixture.getStore()).build();
        QueryEngineSettings qes = (QueryEngineSettings)WhiteboardUtils.getService((Whiteboard)nodeStoreFixture.getWhiteboard(), QueryEngineSettings.class);
        if (qes == null) {
            qes = new QueryEngineSettings();
            nodeStoreFixture.getWhiteboard().register(QueryEngineSettings.class, (Object)qes, Collections.emptyMap());
        }
        qes.setLimitReads(Long.MAX_VALUE);
        Oak oak = new Oak((NodeStore)cns).with(nodeStoreFixture.getWhiteboard());
        Jcr jcr = new Jcr(oak, true);
        return jcr.createRepository();
    }

    public static NodeStoreFixture getNodeStoreFixture(boolean readOnly, String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        Options opts = new Options();
        OptionSet options = opts.parseAndConfigure(parser, args);
        return NodeStoreFixtureProvider.create((Options)opts, (boolean)readOnly);
    }

    public static NodeStoreFixture getNodeStoreFixture(boolean readOnly, File segmentStore, String ... args) throws Exception {
        File possibleFds;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (argList.isEmpty() && (possibleFds = new File(segmentStore.getParentFile(), "datastore")).isDirectory()) {
            argList.add("--fds-path");
            argList.add(possibleFds.getAbsolutePath());
        }
        argList.add(segmentStore.getAbsolutePath());
        return JcrFactory.getNodeStoreFixture(readOnly, argList.toArray(new String[0]));
    }

    public static NodeStoreFixture getReadOnlyFixture(File segmentStore, String ... args) throws Exception {
        return JcrFactory.getNodeStoreFixture(true, segmentStore, args);
    }

    public static NodeStoreFixture getReadWriteFixture(File segmentStore, String ... args) throws Exception {
        return JcrFactory.getNodeStoreFixture(false, segmentStore, args);
    }
}

