/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster.targets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jcr.Session;
import javax.json.JsonArray;
import javax.json.JsonObject;
import net.adamcin.oakpal.api.Rules;
import net.adamcin.oakpal.webster.ArchiveAware;
import net.adamcin.oakpal.webster.CndExporter;
import net.adamcin.oakpal.webster.FileVaultNameFinder;
import net.adamcin.oakpal.webster.QName;
import net.adamcin.oakpal.webster.WebsterTarget;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebsterNodetypesTarget
implements WebsterTarget,
ArchiveAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsterNodetypesTarget.class);
    static final String KEY_SCOPE_EXPORT_NAMES = "scopeExportNames";
    static final String KEY_SCOPE_REPLACE_NAMES = "scopeReplaceNames";
    static final String KEY_INCLUDE_BUILTINS = "includeBuiltins";
    private final File targetFile;
    private final CndExporter exporter;
    private Archive archive;
    private File writeBackDir;

    private WebsterNodetypesTarget(File targetFile, CndExporter exporter) {
        this.targetFile = targetFile;
        this.exporter = exporter;
    }

    @Override
    public void setArchive(Archive archive, File writeBackDir) {
        this.archive = archive;
        this.writeBackDir = writeBackDir;
    }

    @Override
    public void perform(Session session) throws Exception {
        File nodetypesCnd = this.targetFile == null ? new File(this.writeBackDir, "META-INF/vault" + File.separator + "nodetypes.cnd") : this.targetFile;
        ArrayList<String> ntNames = new ArrayList<String>();
        Set<QName> qNames = new FileVaultNameFinder().search(this.archive);
        qNames.stream().filter(qName -> qName.getType() == QName.Type.NODETYPE).map(QName::toString).forEachOrdered(ntNames::add);
        nodetypesCnd.getParentFile().mkdirs();
        this.exporter.writeNodetypes(nodetypesCnd, session, ntNames);
        LOGGER.info("Nodetypes CND written to {}", (Object)nodetypesCnd.getAbsolutePath());
    }

    static WebsterNodetypesTarget fromJson(File target, JsonObject config) {
        LOGGER.debug("[fromJson] fromJson: {}", (Object)config.toString());
        CndExporter.Builder builder = new CndExporter.Builder();
        if (config.containsKey((Object)KEY_SCOPE_EXPORT_NAMES)) {
            List scopeExportNames = Rules.fromJsonArray((JsonArray)config.getJsonArray(KEY_SCOPE_EXPORT_NAMES));
            builder.withScopeExportNames(scopeExportNames);
        }
        if (config.containsKey((Object)KEY_SCOPE_REPLACE_NAMES)) {
            List scopeReplaceNames = Rules.fromJsonArray((JsonArray)config.getJsonArray(KEY_SCOPE_REPLACE_NAMES));
            builder.withScopeReplaceNames(scopeReplaceNames);
        }
        if (config.containsKey((Object)KEY_INCLUDE_BUILTINS)) {
            builder.withIncludeBuiltins(config.getBoolean(KEY_INCLUDE_BUILTINS, false));
        }
        return new WebsterNodetypesTarget(target, builder.build());
    }
}

