/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.webster.targets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import javax.jcr.Session;
import net.adamcin.oakpal.webster.ArchiveAware;
import net.adamcin.oakpal.webster.FileVaultNameFinder;
import net.adamcin.oakpal.webster.PrivilegeXmlExporter;
import net.adamcin.oakpal.webster.QName;
import net.adamcin.oakpal.webster.WebsterTarget;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebsterPrivilegesTarget
implements WebsterTarget,
ArchiveAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsterPrivilegesTarget.class);
    private File targetFile;
    private Archive archive;
    private File writeBackDir;

    WebsterPrivilegesTarget(File targetFile) {
        this.targetFile = targetFile;
    }

    @Override
    public void setArchive(Archive archive, File writeBackDir) {
        this.archive = archive;
        this.writeBackDir = writeBackDir;
    }

    @Override
    public void perform(Session session) throws Exception {
        File privilegesXmlFile = this.targetFile == null ? new File(this.writeBackDir, "META-INF/vault" + File.separator + "privileges.xml") : this.targetFile;
        ArrayList<String> privNames = new ArrayList<String>();
        Set<QName> qNames = new FileVaultNameFinder().search(this.archive);
        qNames.stream().filter(qName -> qName.getType() == QName.Type.PRIVILEGE).map(QName::toString).forEachOrdered(privNames::add);
        privilegesXmlFile.getParentFile().mkdirs();
        PrivilegeXmlExporter.writePrivileges(() -> new OutputStreamWriter((OutputStream)new FileOutputStream(privilegesXmlFile), StandardCharsets.UTF_8), session, privNames, false);
        LOGGER.info("Privileges XML written to {}", (Object)privilegesXmlFile.getAbsolutePath());
    }
}

