/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.crypto.v1;

import java.math.BigInteger;
import net.aholbrook.paseto.crypto.KeyPair;
import net.aholbrook.paseto.crypto.NonceGenerator;
import net.aholbrook.paseto.crypto.exception.ByteArrayLengthException;

public abstract class V1CryptoProvider
implements NonceGenerator {
    public static final int NONCE_SIZE = 32;
    public static final int HKDF_SALT_LEN = 16;
    public static final int SHA384_OUT_LEN = 48;
    public static final int RSA_SIGNATURE_LEN = 256;
    protected static final int HKDF_LEN = 32;
    protected static final int RSA_KEY_SIZE = 2048;
    protected static final BigInteger E = BigInteger.valueOf(65537L);

    public abstract byte[] randomBytes(int var1);

    public NonceGenerator getNonceGenerator() {
        return this;
    }

    public byte[] generateNonce() {
        return this.randomBytes(32);
    }

    public abstract byte[] hkdfExtractAndExpand(byte[] var1, byte[] var2, byte[] var3);

    public abstract byte[] hmacSha384(byte[] var1, byte[] var2);

    public abstract byte[] aes256CtrEncrypt(byte[] var1, byte[] var2, byte[] var3);

    public abstract byte[] aes256CtrDecrypt(byte[] var1, byte[] var2, byte[] var3);

    public abstract byte[] rsaSign(byte[] var1, byte[] var2);

    public abstract boolean rsaVerify(byte[] var1, byte[] var2, byte[] var3);

    public abstract KeyPair rsaGenerate();

    protected final void validateHkdfExtractAndExpand(byte[] salt, byte[] inputKeyingMaterial, byte[] info) {
        if (salt == null) {
            throw new NullPointerException("salt");
        }
        if (inputKeyingMaterial == null) {
            throw new NullPointerException("inputKeyingMaterial");
        }
        if (info == null) {
            throw new NullPointerException("info");
        }
        if (salt.length != 16) {
            throw new ByteArrayLengthException("salt", salt.length, 16, true);
        }
        if (inputKeyingMaterial.length < 1) {
            throw new ByteArrayLengthException("inputKeyingMaterial", inputKeyingMaterial.length, 1, false);
        }
        if (info.length < 1) {
            throw new ByteArrayLengthException("info", info.length, 1, false);
        }
    }

    protected final void validateHmacSha384(byte[] m, byte[] key) {
        if (m == null) {
            throw new NullPointerException("m");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (m.length < 1) {
            throw new ByteArrayLengthException("m", m.length, 1, false);
        }
        if (key.length < 1) {
            throw new ByteArrayLengthException("key", key.length, 1, false);
        }
    }

    private final void validateAes256Ctr(byte[] key, byte[] iv) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (key.length < 1) {
            throw new ByteArrayLengthException("key", key.length, 1, false);
        }
        if (iv.length < 1) {
            throw new ByteArrayLengthException("iv", iv.length, 8, false);
        }
    }

    protected final void validateAes256CtrEncrypt(byte[] m, byte[] key, byte[] iv) {
        this.validateAes256Ctr(key, iv);
        if (m == null) {
            throw new NullPointerException("m");
        }
        if (m.length < 1) {
            throw new ByteArrayLengthException("m", m.length, 1, false);
        }
    }

    protected final void validateAes256CtrDecrypt(byte[] c, byte[] key, byte[] iv) {
        this.validateAes256Ctr(key, iv);
        if (c == null) {
            throw new NullPointerException("c");
        }
        if (c.length < 1) {
            throw new ByteArrayLengthException("c", c.length, 1, false);
        }
    }

    protected final void validateRsaSign(byte[] m, byte[] privateKey) {
        if (m == null) {
            throw new NullPointerException("m");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey");
        }
        if (m.length < 1) {
            throw new ByteArrayLengthException("m", m.length, 1, false);
        }
        if (privateKey.length < 1) {
            throw new ByteArrayLengthException("privateKey", privateKey.length, 1, false);
        }
    }

    protected final void validateRsaVerify(byte[] m, byte[] sig, byte[] publicKey) {
        if (m == null) {
            throw new NullPointerException("m");
        }
        if (sig == null) {
            throw new NullPointerException("sig");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey");
        }
        if (m.length < 1) {
            throw new ByteArrayLengthException("m", m.length, 1, false);
        }
        if (sig.length != 256) {
            throw new ByteArrayLengthException("sig", sig.length, 256, true);
        }
        if (publicKey.length < 1) {
            throw new ByteArrayLengthException("publicKey", publicKey.length, 1, false);
        }
    }
}

