/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.crypto.v2;

import net.aholbrook.paseto.crypto.KeyPair;
import net.aholbrook.paseto.crypto.NonceGenerator;
import net.aholbrook.paseto.crypto.exception.ByteArrayLengthException;
import net.aholbrook.paseto.crypto.exception.ByteArrayRangeException;

public abstract class V2CryptoProvider
implements NonceGenerator {
    public static final int BLAKE2B_BYTES_MIN = 16;
    public static final int BLAKE2B_BYTES_MAX = 64;
    public static final int BLAKE2B_KEYBYTES_MIN = 16;
    public static final int BLAKE2B_KEYBYTES_MAX = 64;
    public static final int XCHACHA20_POLY1305_IETF_NPUBBYTES = 24;
    public static final int XCHACHA20_POLY1305_IETF_ABYTES = 16;
    public static final int ED25519_BYTES = 64;
    public static final int ED25519_PUBLICKEYBYTES = 32;
    public static final int ED25519_SECRETKEYBYTES = 64;

    public abstract boolean blake2b(byte[] var1, byte[] var2, byte[] var3);

    public abstract byte[] randomBytes(int var1);

    public abstract boolean aeadXChaCha20Poly1305IetfEncrypt(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    public abstract boolean aeadXChaCha20Poly1305IetfDecrypt(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    public abstract boolean ed25519Sign(byte[] var1, byte[] var2, byte[] var3);

    public abstract boolean ed25519Verify(byte[] var1, byte[] var2, byte[] var3);

    public abstract byte[] ed25519SkToPk(byte[] var1);

    public abstract KeyPair ed25519Generate();

    public NonceGenerator getNonceGenerator() {
        return this;
    }

    public byte[] generateNonce() {
        return this.randomBytes(24);
    }

    public int xChaCha20Poly1305IetfNpubbytes() {
        return 24;
    }

    public int xChaCha20Poly1305IetfAbytes() {
        return 16;
    }

    public int ed25519SignBytes() {
        return 64;
    }

    public int ed25519SignPublicKeyBytes() {
        return 32;
    }

    public int ed25519SignSecretKeyBytes() {
        return 64;
    }

    protected final void validateBlake2b(byte[] out, byte[] in, byte[] key) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (out.length < 16 || out.length > 64) {
            throw new ByteArrayRangeException("out", out.length, 16, 64);
        }
        if (key.length < 16 || key.length > 64) {
            throw new ByteArrayRangeException("key", key.length, 16, 64);
        }
    }

    private final void validateAeadXChaCha20Poly1305Ietf(byte[] out, byte[] in, byte[] ad, byte[] nonce, byte[] key) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (ad == null) {
            throw new NullPointerException("ad");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (in.length == 0) {
            throw new ByteArrayLengthException("in", in.length, 1, false);
        }
        if (ad.length == 0) {
            throw new ByteArrayLengthException("ad", ad.length, 1, false);
        }
        if (key.length == 0) {
            throw new ByteArrayLengthException("key", key.length, 1, false);
        }
        if (nonce.length != 24) {
            throw new ByteArrayLengthException("nonce", nonce.length, 24);
        }
    }

    protected final void validateAeadXChaCha20Poly1305IetfEncrypt(byte[] out, byte[] in, byte[] ad, byte[] nonce, byte[] key) {
        this.validateAeadXChaCha20Poly1305Ietf(out, in, ad, nonce, key);
        if (out.length != in.length + 16) {
            throw new ByteArrayLengthException("out", out.length, in.length + 16);
        }
    }

    protected final void validateAeadXChaCha20Poly1305IetfDecrypt(byte[] out, byte[] in, byte[] ad, byte[] nonce, byte[] key) {
        this.validateAeadXChaCha20Poly1305Ietf(out, in, ad, nonce, key);
        if (out.length != in.length - 16) {
            throw new ByteArrayLengthException("out", out.length, in.length - 16);
        }
    }

    protected final void validateEd25519Sign(byte[] sig, byte[] m, byte[] sk) {
        if (sig == null) {
            throw new NullPointerException("sig");
        }
        if (m == null) {
            throw new NullPointerException("m");
        }
        if (sk == null) {
            throw new NullPointerException("sk");
        }
        if (sig.length != 64) {
            throw new ByteArrayLengthException("sig", sig.length, 64);
        }
        if (m.length == 0) {
            throw new ByteArrayLengthException("m", 0, 1, false);
        }
        if (sk.length != 64) {
            throw new ByteArrayLengthException("sk", sk.length, 64);
        }
    }

    protected final void validateEd25519Verify(byte[] sig, byte[] m, byte[] pk) {
        if (sig == null) {
            throw new NullPointerException("sig");
        }
        if (m == null) {
            throw new NullPointerException("m");
        }
        if (pk == null) {
            throw new NullPointerException("pk");
        }
        if (sig.length != 64) {
            throw new ByteArrayLengthException("sig", sig.length, 64);
        }
        if (m.length == 0) {
            throw new ByteArrayLengthException("m", 0, 1, false);
        }
        if (pk.length != 32) {
            throw new ByteArrayLengthException("pk", pk.length, 32);
        }
    }

    protected final void validateEd25519PublicKey(byte[] sk) {
        if (sk == null) {
            throw new NullPointerException("sk");
        }
        if (sk.length != 64) {
            throw new ByteArrayLengthException("sk", sk.length, 64);
        }
    }
}

