/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.time;

import java.time.Instant;
import java.time.ZoneId;
import net.aholbrook.paseto.time.Clock;
import net.aholbrook.paseto.time.Duration;
import net.aholbrook.paseto.time.temporal.ChronoUnit;

public class OffsetDateTime {
    private final java.time.OffsetDateTime offsetDateTime;

    public OffsetDateTime(java.time.OffsetDateTime offsetDateTime) {
        this.offsetDateTime = offsetDateTime;
    }

    public java.time.OffsetDateTime raw() {
        return this.offsetDateTime;
    }

    public static OffsetDateTime now() {
        return new OffsetDateTime(java.time.OffsetDateTime.now());
    }

    public static OffsetDateTime now(Clock systemUTC) {
        return new OffsetDateTime(java.time.OffsetDateTime.now(systemUTC.raw()));
    }

    public OffsetDateTime truncatedTo(ChronoUnit seconds) {
        return new OffsetDateTime(this.offsetDateTime.truncatedTo(seconds.raw()));
    }

    public OffsetDateTime plus(Duration d) {
        return new OffsetDateTime(this.offsetDateTime.plus(d.raw()));
    }

    public OffsetDateTime minus(Duration d) {
        return new OffsetDateTime(this.offsetDateTime.minus(d.raw()));
    }

    public boolean isBefore(OffsetDateTime time) {
        return this.offsetDateTime.isBefore(time.raw());
    }

    public boolean isAfter(OffsetDateTime time) {
        return this.offsetDateTime.isAfter(time.raw());
    }

    public OffsetDateTime plusSeconds(int l) {
        return new OffsetDateTime(this.offsetDateTime.plusSeconds(l));
    }

    public OffsetDateTime minusSeconds(long l) {
        return new OffsetDateTime(this.offsetDateTime.minusSeconds(l));
    }

    public OffsetDateTime plusMinutes(long l) {
        return new OffsetDateTime(this.offsetDateTime.plusMinutes(l));
    }

    public OffsetDateTime minusMinutes(long l) {
        return new OffsetDateTime(this.offsetDateTime.minusMinutes(l));
    }

    public long toEpochSecond() {
        return this.offsetDateTime.toEpochSecond();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetDateTime that = (OffsetDateTime)o;
        return this.offsetDateTime.equals(that.offsetDateTime);
    }

    public int hashCode() {
        return this.offsetDateTime.hashCode();
    }

    public String toString() {
        return this.offsetDateTime.toString();
    }

    public static OffsetDateTime ofEpochSecond(long l) {
        return new OffsetDateTime(java.time.OffsetDateTime.ofInstant(Instant.ofEpochSecond(l), ZoneId.of("UTC")));
    }

    public OffsetDateTime plusDays(long l) {
        return new OffsetDateTime(this.offsetDateTime.plusDays(l));
    }
}

