/*
 * Decompiled with CFR 0.152.
 */
package net.aichler.jupiter.internal.event;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;

class TaskName {
    private String fullyQualifiedName;
    private String nestedSuiteId;
    private String testName;
    private String invocation;

    TaskName() {
    }

    String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    String nestedSuiteId() {
        return this.nestedSuiteId;
    }

    String testName() {
        return this.testName;
    }

    String invocation() {
        return this.invocation;
    }

    static TaskName of(String string, String string2) {
        if (!string.equals(string2)) {
            throw new RuntimeException(string + " != " + string2);
        }
        TaskName taskName = new TaskName();
        taskName.fullyQualifiedName = string2;
        return taskName;
    }

    static TaskName of(String string, TestIdentifier testIdentifier) {
        ClassSource classSource;
        TaskName taskName = new TaskName();
        taskName.fullyQualifiedName = string;
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof ClassSource) {
            classSource = (ClassSource)testSource;
            taskName.nestedSuiteId = TaskName.nestedSuiteId(string, classSource.getClassName());
        }
        if (testSource instanceof MethodSource) {
            classSource = (MethodSource)testSource;
            taskName.nestedSuiteId = TaskName.nestedSuiteId(string, classSource.getClassName());
            taskName.invocation = TaskName.invocation(UniqueId.parse((String)testIdentifier.getUniqueId()));
            taskName.testName = TaskName.testName(classSource.getMethodName(), classSource.getMethodParameterTypes());
        }
        return taskName;
    }

    static String nestedSuiteId(String string, String string2) {
        if (!string2.startsWith(string)) {
            throw new RuntimeException("Test class " + string2 + " is not enclosed by " + string);
        }
        if (!string2.equals(string)) {
            return string2.substring(string.length());
        }
        return null;
    }

    static String testName(String string2, String string3) {
        String string4 = "";
        if (null != string3 && !string3.isEmpty()) {
            String[] stringArray = string3.split(",\\s*");
            string4 = Arrays.stream(stringArray).map(string -> {
                int n = string.lastIndexOf(46);
                return n < 0 ? string : string.substring(n + 1);
            }).collect(Collectors.joining(", "));
        }
        return string2 + "(" + string4 + ")";
    }

    static String invocation(UniqueId uniqueId) {
        List list = uniqueId.getSegments();
        if (!list.isEmpty()) {
            UniqueId.Segment segment = (UniqueId.Segment)list.get(list.size() - 1);
            switch (segment.getType()) {
                case "dynamic-test": 
                case "test-template-invocation": {
                    return segment.getValue().replace("#", "");
                }
            }
        }
        return null;
    }
}

