package net.aihelp.common;

import android.content.pm.ActivityInfo;

import net.aihelp.config.enums.ShowConversationMoment;
import net.aihelp.data.model.init.PrivacyControlEntity;

public class CustomConfig {

    public static class CommonSetting {
        // =========================== UI ===========================
        // 导航栏背景色、透明度
        public static String navigationBarBackground = "#FFFFFF";
        public static double navigationBarAlpha = 1;

        // 横竖屏颜色或背景
        public static String backgroundColorForAll = "#FFFFFF";
        public static String backgroundImageForPortrait = "";
        public static String backgroundImageForLandscape = "";

        // 搜索框背景、FAQ列表背景、分类列表背景、机器人消息气泡背景、客服消息气泡背景、表单填写框背景等
        public static String upperBackgroundColor = "#F2F3F4";
        public static double upperBackgroundAlpha = 1;

        // 标题文字、FAQ列表文字、分类列表文字、按钮文字、搜索输入文字、机器人消息文字等
        public static String textColor = "#333940";

        // 通知栏文字、FAQ 搜索关键词
        public static String highlightedColor = "#FA8A1B";

        // 联系客服按钮、提建议按钮、好评差评按钮、机器人Action、超链接等
        public static String interactElementTextColor = "#1B8AFA";

        // =========================== Toggle ============================
        // 整体页面背景是否是图片
        public static boolean isBackgroundRenderedWithImage = false;

        // CustomerService 是否开启机器人客服内 FAQ 评价、Faq 点踩后是否允许负反馈
        public static boolean isEvaluationForBotEnable = false;
        public static boolean isEvaluationForAnswerPageEnable = false;
        public static boolean isEvaluationForOperationEnable = false;
        public static boolean isFaqUnhelpfulFeedbackEnable = false;

        // =========================== Text ============================
        public static String commonPositiveFeedbackHint = "";
        public static String commonNegativeFeedbackHint = "";

        // =========================== Others ============================
        public static int screenOrientation = ConfigValues.SCREEN_ORIENTATION_PORTRAIT;
        public static PrivacyControlEntity privacyControlData = null;
        public static boolean isLandscape = false;

    }

    public static class HelpCenter {
        // =========================== UI ============================
        // 帮助中心导航栏标题图标
        public static String faqNavigationBarTitleIcon = "";

        // 帮助中心通知栏图标 & 轮播间隔
        public static String faqNotificationIcon = "";
        public static int faqNotificationInterval = 3;

        // 帮助中心热门问题的标题图标 & 分类模块的标题图标
        public static String faqHotTopicTitleIcon = "";
        public static String faqSectionTitleIcon = "";

        // =========================== Toggle ============================
        // Faq 标题 icon 是否可见
        public static boolean isFaqTitleIconVisible = true;

        // Faq 搜索栏是否可见
        public static boolean isFaqSearchVisible = true;

        // Faq 通知栏是否可见、通知栏图标是否可见
        public static boolean isFaqNotificationVisible = true;
        public static boolean isFaqNotificationIconVisible = true;

        // Faq 热门问题模块是否可见、热门模块的标题是否可见、标题图标是否可见、列表项图标是否可见
        public static boolean isFaqHotTopicVisible = true;
        public static boolean isFaqHotTopicTitleVisible = true;
        public static boolean isFaqHotTopicTitleIconVisible = true;
        public static boolean isFaqHotTopicItemIconVisible = true;

        // Faq 分类模块是否可见、分类模块的标题是否可见、标题图标是否可见、列表项图标是否可见、整个模块是否按列表展示
        public static boolean isFaqSectionTitleVisible = true;
        public static boolean isFaqSectionTitleIconVisible = true;
        public static boolean isFaqSectionItemIconVisible = true;
        public static boolean isFaqSectionDisplayAsList = false;

        // =========================== Text ============================
        public static String faqNavigationTitle = "";
        public static String faqSearchHint = "";
        public static String faqHotTopicsTitle = "";
        public static String faqSectionTitle = "";
        public static String faqCSEntranceText = "";
    }

    public static class CustomerService {
        // =========================== UI ===========================
        // 在线客服导航栏标题图标
        public static String csNavigationBarTitleIcon = "";

        // 在线客服机器人、人工客服以及用户头像
        public static String csBotSupportPortrait = "";
        public static String csManualSupportPortrait = "";
        public static String csUserPortrait = "";

        // =========================== Toggle ===========================
        // CustomerService 头像是否可见、客服昵称是否可见、消息发送时间是否可见、是否允许获取历史消息
        public static boolean isCsTitleIconVisible = false;
        public static boolean isPortraitVisible = false;
        public static boolean isNicknameVisible = false;
        public static boolean isMessageTimestampVisible = false;
        public static boolean isHistoryChatEnable = false;

        // CustomerService 是否进行确认解决调查、是否开启满意度调查、是否允许邀请评价应用、是否允许差评后反馈
        public static boolean isTicketRatingEnable = true;
        public static boolean isEvaluateBadServiceEnable = true;
        public static boolean isUnhelpfulFaqStoryNodeEnable = false;
        public static boolean isBotResolveQueryEnable = false;

        // =========================== Text ============================
        public static String csNavigationTitle = "";
        public static String csWelcomeMessage = "";
        public static String csInputHint = "";
        public static String csInviteEvaluate = "";

        // =========================== Others ===========================
        // 在线客服满意度调查
        public static int csEvaluateMaxCount = 3;
    }

}
