package net.aihelp.core.net.mqtt.hawtdispatch;

/**
 * <p>
 * Defines the supported global/concurrent queue priorities.
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public enum DispatchPriority {
    /**
     * Items dispatched to the queue will run at high priority,
     * i.e. the queue will be scheduled for execution before
     * any default priority or low priority queue.
     */
    HIGH,
    /**
     * Items dispatched to the queue will run at the default
     * priority, i.e. the queue will be scheduled for execution
     * after all high priority queues have been scheduled, but
     * before any low priority queues have been scheduled.
     */
    DEFAULT,
    /**
     * Items dispatched to the queue will run at low priority,
     * i.e. the queue will be scheduled for execution after all
     * default priority and high priority queues have been
     * scheduled.
     */
    LOW;
}