package net.aihelp.core.net.mqtt.hawtdispatch;


/**
 * <p>
 * The EventAggregator interface is used by the {@link CustomDispatchSource} objects to handle
 * coalescing data before passing it to the application.  Implementations of this class should
 * be stateless to remain thread-safe.  You can also use one of several built in implementations:
 * </p>
 *
 * <ul>
 * <li>{@link EventAggregators#INTEGER_ADD}</li>
 * <li>{@link EventAggregators#INTEGER_OR}</li>
 * <li>{@link EventAggregators#LONG_ADD}</li>
 * <li>{@link EventAggregators#LONG_OR}</li>
 * </ul>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public interface EventAggregator<Event, MergedEvent> {

    /**
     * <p>
     * Merge the given event with the previous event values.
     * </p>
     *
     * @param previous may be null
     * @param event the value that should be merged
     * @return a newly merged result
     */
    public MergedEvent mergeEvent(MergedEvent previous, Event event);

    /**
     * <p>
     * Merge the given events with the previous event values.
     * </p>
     *
     * @param previous the value of previous merges
     * @param events the value of more merges
     * @return a newly merged result
     */
    public MergedEvent mergeEvents(MergedEvent previous, MergedEvent events);

}