package net.aihelp.core.net.mqtt.hawtdispatch.internal.util;

import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.TaskWrapper;

import java.util.concurrent.atomic.AtomicInteger;

/**
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class RunnableSupport {

    private static Task NO_OP = new Task() {
        public void run() {
        }
        public String toString() {
            return "{}";
        };
    };

    public static Task runNoop() {
        return NO_OP;
    }

    public static Task runOnceAfter(final Runnable runnable, int count) {
        return runOnceAfter(new TaskWrapper(runnable), count);
    }

    public static Task runOnceAfter(final Task runnable, int count) {
        if( runnable==null ) {
            return NO_OP;
        }
        if( count == 0 ) {
            runnable.run();
            return NO_OP;
        }
        if( count == 1 ) {
            return runnable;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task() {
            public void run() {
                if( counter.decrementAndGet()==0 ) {
                    runnable.run();
                }
            }
            public String toString() {
                return "{"+runnable+"}";
            };
        };
    }

    public static Task runAfter(final Runnable runnable, int count) {
        return runAfter(new TaskWrapper(runnable), count);
    }
    public static Task runAfter(final Task runnable, int count) {
        if( count <= 0 || runnable==null ) {
            return NO_OP;
        }
        if( count == 1 ) {
            return runnable;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task() {
            public void run() {
                if( counter.decrementAndGet()<=0 ) {
                    runnable.run();
                }
            }
            public String toString() {
                return "{"+runnable+"}";
            };
        };
    }

    public static Task runOnceAfter(final DispatchQueue queue, final Runnable runnable, int count) {
        return runOnceAfter(queue, new TaskWrapper(runnable), count);
    }
    public static Task runOnceAfter(final DispatchQueue queue, final Task task, int count) {
        if( count <= 0 || task==null ) {
            return NO_OP;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task() {
            public void run() {
                if( counter.decrementAndGet()==0 ) {
                    queue.execute(task);
                }
            }
            public String toString() {
                return "{"+task+"}";
            };
        };
    }

    public static Task runAfter(final DispatchQueue queue, final Runnable runnable, int count) {
        return runAfter(queue, new TaskWrapper(runnable), count);
    }

    public static Task runAfter(final DispatchQueue queue,  final Task task, int count) {
        if( count <= 0 || task==null ) {
            return NO_OP;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task() {
            public void run() {
                if( counter.decrementAndGet()<=0 ) {
                    queue.execute(task);
                }
            }
            public String toString() {
                return "{"+task.toString()+"}";
            };
        };
    }


}
