package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.aihelp.core.util.elva.Match;

public class Sentence extends TemplateElement {

    public Sentence(Attributes attributes) {
    }

    public Sentence(Object... children) {
        super(children);
    }

    public String process(Match match) {
        String result = super.process(match);
        if (result == null || "".equals(result.trim())) {
            return "";
        }
        Pattern p = Pattern.compile("(^[ \\s]*[a-z]|[\\.\\?!]+[ \\s]*[a-z])");
        Matcher m = p.matcher(result);
        StringBuffer buffer = new StringBuffer();
        while (m.find()){
            m.appendReplacement(buffer, m.group().toUpperCase());
        }
        m.appendTail(buffer);
        return buffer.toString();
    }
}