package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.Context;
import net.aihelp.core.util.elva.Match;

public class Set extends TemplateElement {

    private String name;

    public Set(Attributes attributes) {
        name = attributes.getValue(0);
    }

    public Set(String name, Object... children) {
        super(children);
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Set compared = (Set) obj;
        if (!name.equals(compared.name)) {
            return false;
        }
        return super.equals(compared);
    }

    public String process(Match match) {
        String output = super.process(match);
        if (match == null) {
            output = "<set name=\"" + name + "\">" + output + "</set>";
        } else {
            ElvaBot bot = match.getCallback();
            Context context = (bot != null ? bot.getContext() : null);
            if (context != null) context.property("predicate." + name, output);
        }
        return output;
    }
}