package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

import static net.aihelp.core.util.elva.Match.Section.TOPIC;

public class Topicstar extends TemplateElement {

    private int index;

    public Topicstar(Attributes attributes) {
        String value = attributes.getValue(0);
        if (value == null) {
            index = 1;
        } else {
            index = Integer.parseInt(value);
        }
    }

    public Topicstar(int index) {
        this.index = index;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Topicstar compared = (Topicstar) obj;
        return (index == compared.index);
    }

    public String toString() {
        return "<topicstar index=\"" + index + "\">";
    }

    public String process(Match match) {
        String wildcard = match.wildcard(TOPIC, index);
        return (wildcard != null ? wildcard.trim() : "");
    }
}