package net.aihelp.core.util.elva.aiml;

import android.text.TextUtils;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

public class Url extends TemplateElement {

    private String title;
    private String content;
    private String orderInfo;

    public Url() {
    }

    public Url(Attributes attributes) {
        title = attributes.getValue("title");
        content = attributes.getValue("content");
        orderInfo = attributes.getValue("orderInfo");
    }

    public Url(String title, String content, String orderinfo, Object... children) {
        super(children);
        this.title = title;
        this.content = content;
        this.orderInfo = orderinfo;
    }
  
    private boolean isEquals(Object comparing, Object compared) {
        return (comparing == null ? compared == null : comparing.equals(compared));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Url compared = (Url) obj;
        return (isEquals(title, compared.title) && isEquals(content, compared.content)
                && isEquals(orderInfo, compared.orderInfo));
    }
  
    public String getTitle() {
        return TextUtils.isEmpty(title) ? "" : title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return TextUtils.isEmpty(content) ? "" : content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOrderInfo() {
        return TextUtils.isEmpty(orderInfo) ? "" : orderInfo;
    }

    public void setOrderInfo(String orderInfo) {
        this.orderInfo = orderInfo;
    }

    public String process(Match match) {
        try {
            return String.format("<url title='%s' content='%s' orderInfo='%s'></url>",
                    getTitle().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"),
                    getContent().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"),
                    getOrderInfo().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;")
            );
        } catch (NullPointerException e) {
            return "";
        }
    }
}