package net.aihelp.core.util.elva.parser;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.Context;
import net.aihelp.core.util.elva.Graphmaster;
import net.aihelp.core.util.elva.aiml.AIMLParser;
import net.aihelp.core.util.elva.text.Transformations;
import net.aihelp.utils.TLog;

public class ElvaBotParser {

    //  private Class<? extends Context> contextClass = Context.class;
//  private Class<? extends Graphmaster> graphmasterClass = Graphmaster.class;
    private AIMLParser aimlParser;
    private ContextParser contParser;
    private TransformationsParser normParser;
    private String appId;
    private String languageId;
    private static Map<String, Map<String, Graphmaster>> mapGraph = new ConcurrentHashMap<>();
//  private static final Logger logger = LoggerFactory.getLogger(AliceBotParser.class);

    public ElvaBotParser() {
        try {
            aimlParser = new AIMLParser();
            contParser = new ContextParser();
            normParser = new TransformationsParser();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ElvaBotParser(String appId, String languageId) {
        this();
        this.appId = appId;
        this.languageId = languageId;
    }

    public boolean containsGraph() {
        Map<String, Graphmaster> map = mapGraph.get(appId);
        return map != null && map.containsKey(languageId);
    }

    public static void removeMapGraph(String appId) {
        Map<String, Graphmaster> map = mapGraph.get(appId);
        if (map != null) {
            map.clear();
        }
    }

    private Context newContext(InputStream defaults, InputStream splitters, InputStream substitutions) throws Exception {
        Context context = new Context();
        contParser.parse(context, defaults);
        Transformations transformations = normParser.parse(splitters, substitutions);
        context.setTransformations(transformations);
        return context;
    }

    private Graphmaster newGraphmaster(InputStream... aiml) {
        if (aiml == null) return null;
        Graphmaster graphmaster = new Graphmaster();
        aimlParser.parse(graphmaster, aiml);
        return graphmaster;
    }

    public void parse(ElvaBot bot, InputStream defaults, InputStream splitters, InputStream substitutions, InputStream... aiml) {
        try {
            Context context = newContext(defaults, splitters, substitutions);
            bot.setContext(context);
            Map<String, Graphmaster> map = mapGraph.get(appId);
            if (map == null) {
                map = new HashMap<>();
                mapGraph.put(appId, map);
            }
            Graphmaster graphmaster = map.get(this.languageId);
            if (graphmaster == null) {
                graphmaster = newGraphmaster(aiml);
                map.put(languageId, graphmaster);
            }
            bot.setGraphmaster(graphmaster);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ElvaBot parse(InputStream defaults, InputStream splitters, InputStream substitutions, InputStream... aiml) {
        try {
            ElvaBot bot = new ElvaBot();
            parse(bot, defaults, splitters, substitutions, aiml);
            return bot;
        } catch (Exception e) {
            TLog.e("ElvaBot parse exception -> " + e.toString());
            return null;
        }
    }

//  public <C extends Context> void contextClass(Class<C> contextClass)
//  {
//    this.contextClass = contextClass;
//  }

//  public <M extends Graphmaster> void graphmasterClass(Class<M> graphmasterClass)
//  {
//    this.graphmasterClass = graphmasterClass;
//  }
}