package net.aihelp.core.util.elva.text;

import java.util.Arrays;

public class Sentence {

    private String original;
    private Integer[] mappings; // The index mappings of normalized elements to original elements.
    private String normalized;
    private String[] splitted; // The normalized entry, splitted in an array of words.

    public static final Sentence ASTERISK = new Sentence(" * ", new Integer[]{0, 2}, " * ");

    public Sentence(String original, Integer[] mappings, String normalized) {
        setOriginal(original);
        setMappings(mappings);
        setNormalized(normalized);
    }

    public Sentence(String original) {
        this(original, null, null);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Sentence)) {
            return false;
        }
        Sentence compared = (Sentence) obj;
        return (original.equals(compared.original) &&
                Arrays.equals(mappings, compared.mappings) &&
                normalized.equals(compared.normalized));
    }

    public int length() {
        return splitted.length;
    }

    public String[] normalized() {
        return splitted;
    }

    public String normalized(int index) {
        return splitted[index];
    }

    public String original(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(beginIndex);
        }
        while (beginIndex >= 0 && mappings[beginIndex] == null) {
            beginIndex--;
        }
        int n = mappings.length;
        while (endIndex < n && mappings[endIndex] == null) {
            endIndex++;
        }
        if (endIndex >= n) {
            endIndex = n - 1;
        }
        if (beginIndex >= 0 && endIndex >= 0 && mappings[beginIndex] != null && mappings[endIndex] != null) {
            String value = original.substring(mappings[beginIndex], mappings[endIndex] + 1);
            value = value.replaceAll("^[^A-Za-z0-9\\u4E00-\\u9FA5\\u3040-\\u31FE\\u0400-\\u04FF\\u0E00-\\u0E7F\\uAC00-\\uD7AF\\u0600-\\u06FF\\u0080-\\u00FF\\u0100-\\u017F]+|[^A-Za-z0-9\\u4E00-\\u9FA5\\u3040-\\u31FE\\u0400-\\u04FF\\u0E00-\\u0E7F\\uAC00-\\uD7AF\\u0600-\\u06FF\\u0080-\\u00FF\\u0100-\\u017F]+$", " ");
            return value;
        } else return "";
    }

    public String toString() {
        return "[" + original + "]" + Arrays.toString(mappings) + "[" + normalized + "]";
    }

    public String trimOriginal() {
        return original.trim();
    }

    public Integer[] getMappings() {
        return mappings;
    }

    public void setMappings(Integer[] mappings) {
        this.mappings = mappings;
    }

    public String getNormalized() {
        return normalized;
    }

    public void setNormalized(String normalized) {
        this.normalized = normalized;
        if (normalized != null) {
            splitted = normalized.trim().split(" ");
        }
    }

    public String getOriginal() {
        return original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }
}