package net.aihelp.core.util.elva.util;

import java.util.regex.Pattern;

public class ParseUtil {

    public static boolean needBlankSplit(String qname) {
        return qname.toLowerCase().equals("pattern") || qname.toLowerCase().equals("that");
    }

    // 判断input中的东亚文本，将中文用空格隔开
    public static String blankSplit(String input) {
        final Pattern asianChar = Pattern.compile("[\u4E00-\u9FA5\uAC00-\uD7AF\u3040-\u31FE]+");
        if (input.length() == 0)
            return input;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); i++) {
            String s = input.substring(i, i + 1);
            if (Pattern.matches(asianChar.pattern(), s)) {
                sb.append(" ").append(s).append(" ");
            } else
                sb.append(s);
        }
        return sb.toString();
    }
}