package net.aihelp.core.util.permission;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Permission {

    int requestCode() default 0;

    enum State{
        AVAILABLE,
        UNAVAILABLE,
        ASKABLE,
        RATIONAL
    }

    enum Result{
        GRANTED,
        DENIED,
        RATIONAL,
        GO_SETTING,
        NONE
    }

}
