//package net.aihelp.data.localize.data;
//
//import android.text.TextUtils;
//
//import net.aihelp.common.Const;
//import net.aihelp.core.net.json.JsonHelper;
//import net.aihelp.data.localize.LocalizeHelper;
//import net.aihelp.data.localize.util.LocalizeUtil;
//import net.aihelp.data.model.faq.FaqContentEntity;
//import net.aihelp.data.model.faq.FaqListEntity;
//import net.aihelp.utils.FileUtil;
//import net.aihelp.utils.Styles;
//
//import org.json.JSONArray;
//import org.json.JSONObject;
//
//import java.util.ArrayList;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
//public enum FaqHotTopicHelper {
//
//    INSTANCE;
//
//    private List<FaqListEntity> notificationList = new ArrayList<>();
//    private Map<String, FaqContentEntity> notificationMap = new HashMap<>();
//
//    private List<FaqListEntity> hotTopicList = new ArrayList<>();
//    private Map<String, FaqContentEntity> hotTopicMap = new HashMap<>();
//
//    public List<FaqListEntity> getNotificationList() {
//        return notificationList;
//    }
//
//    public List<FaqListEntity> getHotTopicList() {
//        return hotTopicList;
//    }
//
//    public FaqContentEntity getFaqById(String faqId) {
//        FaqContentEntity resultFaq = hotTopicMap.get(faqId);
//        if (resultFaq == null) {
//            resultFaq = notificationMap.get(faqId);
//        }
//        return resultFaq;
//    }
//
//    public void prepareDataSource() {
//        try {
//            // 从本地读取 FAQ 文件
//            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(LocalizeHelper.FLAG_FAQ_HOT_TOPIC));
//            if (!TextUtils.isEmpty(content)) {
//                JSONObject jsonObject = new JSONObject(content);
//                prepareNotificationList(JsonHelper.getJsonArray(jsonObject, "notice"));
//                prepareHotTopicList(JsonHelper.getJsonArray(jsonObject, "faqList"));
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    private void prepareNotificationList(JSONArray faqs) {
//        if (faqs != null && faqs.length() > 0) {
//            for (int i = 0; i < faqs.length(); i++) {
//                JSONObject faq = JsonHelper.getJsonObject(faqs, i);
//                String mainId = faq.optString("kmMainid");
//                notificationList.add(new FaqListEntity(FaqListEntity.FAQ_DISPLAY_NOTIFICATION,
//                        mainId, faq.optString("question")
//                ));
//                notificationMap.put(mainId, getFaqContentEntity(faq));
//            }
//        }
//    }
//
//    private void prepareHotTopicList(JSONArray faqs) {
//        if (faqs != null && faqs.length() > 0) {
//            for (int i = 0; i < faqs.length(); i++) {
//                JSONObject faq = JsonHelper.getJsonObject(faqs, i);
//                String mainId = faq.optString("kmMainid");
//                hotTopicList.add(new FaqListEntity(FaqListEntity.FAQ_DISPLAY_HOT_TOPICS,
//                        mainId, faq.optString("question")
//                ));
//                hotTopicMap.put(mainId, getFaqContentEntity(faq));
//            }
//        }
//    }
//
//    private FaqListEntity getFaqListEntity(int displayType, JSONObject faq) {
//        FaqListEntity entity = new FaqListEntity(displayType, faq.optString("kmMainid"), faq.optString("question"));
//        entity.setIconUrl(JsonHelper.optString(faq, "imgUrl"));
//        return entity;
//    }
//
//    private FaqContentEntity getFaqContentEntity(JSONObject faq) {
//        FaqContentEntity faqEntity = new FaqContentEntity();
//        faqEntity.setFaqMainId(faq.optString("kmMainid"));
//        faqEntity.setFaqDisplayId(faq.optString("faqId"));
//        faqEntity.setFaqContentId(faq.optString("kmContentId"));
//        faqEntity.setFaqTitle(faq.optString("question"));
//        faqEntity.setFaqKeywords(faq.optString("keyWords"));
//        faqEntity.setSimilarQuestions(faq.optString("similarQuestions"));
//        faqEntity.setFaqContent(faq.optString("content"));
//        faqEntity.setFaqNoHtmlContent(Styles.getNoTemplateFaqContent(faq.optString("content")));
//        return faqEntity;
//    }
//
//}
